/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Vector;

public abstract class Compiler
implements Symbols {
    protected String sourceFileName;
    protected String objectFileName;
    protected LexicalAnalyzer lex;
    protected Integer sym;
    protected SymbolTable symTab;
    protected JerooNameTable nameTab;
    protected Vector code;
    protected int codeIndex;
    protected BufferedWriter out;
    protected Vector jumpLabels;
    protected int instanceCount;
    protected int currentJeroo;
    protected HashSet builtinMethodSet;
    protected HashSet statmntBeg;
    protected HashSet compassDirs;
    protected String sourceFileHeader;

    public Compiler(String string) {
        this.sourceFileHeader = string;
        this.symTab = new SymbolTable();
        this.nameTab = JerooNameTable.getInstance();
        this.code = new Vector();
        this.jumpLabels = new Vector();
        this.codeIndex = 0;
        this.instanceCount = 0;
        this.currentJeroo = -1;
        this.builtinMethodSet = new HashSet();
        this.builtinMethodSet.add(HOP);
        this.builtinMethodSet.add(TOSS);
        this.builtinMethodSet.add(PICK);
        this.builtinMethodSet.add(TURN);
        this.builtinMethodSet.add(PLANT);
        this.builtinMethodSet.add(GIVE);
        this.statmntBeg = new HashSet();
        this.compassDirs = new HashSet();
        this.compassDirs.add(NORTH);
        this.compassDirs.add(SOUTH);
        this.compassDirs.add(EAST);
        this.compassDirs.add(WEST);
    }

    public abstract void compile(String var1, String var2) throws FileNotFoundException, IOException, CompileException;

    protected abstract void method() throws IOException, CompileException;

    protected abstract void declarations() throws IOException, CompileException;

    protected abstract void declaration() throws IOException, CompileException;

    protected abstract void firstPass() throws IOException, CompileException;

    protected void statements(String string) throws IOException, CompileException {
        if (string.equals("METHOD")) {
            while (this.statmntBeg.contains(this.sym) || this.builtinMethodSet.contains(this.sym)) {
                this.statement(string);
            }
        } else {
            while (this.statmntBeg.contains(this.sym)) {
                this.statement(string);
            }
        }
    }

    protected abstract void statement(String var1) throws IOException, CompileException;

    protected void jerooInstance() throws CompileException {
        this.jerooInstance(this.lex.getCurrPane(), this.lex.getRelativeLine());
    }

    protected void jerooInstance(int n, int n2) throws CompileException {
        SymbolTableEntry symbolTableEntry = this.symTab.findEntry(this.lex.getLastIdentifier());
        if (symbolTableEntry == null) {
            this.error(12);
        }
        if (symbolTableEntry.getType().equals("jeroo")) {
            InstanceEntry instanceEntry = (InstanceEntry)symbolTableEntry;
            int n3 = instanceEntry.getJerooNum();
            if (n3 != this.currentJeroo) {
                this.genCode("CSR", n3, 0, 0, 0, 0, n, n2);
                this.currentJeroo = n3;
            }
        } else {
            this.error(21);
        }
    }

    protected void predefMethodCall() throws IOException, CompileException {
        Integer n = this.sym;
        this.sym = this.lex.getSym();
        if (!this.sym.equals(LPAREN)) {
            this.error(3);
        }
        if (n.equals(HOP)) {
            int n2 = 1;
            this.sym = this.lex.peekAhead();
            if (this.sym.equals(INTSYM)) {
                this.sym = this.lex.getSym();
                n2 = this.lex.getLastNumber();
            }
            this.genCode("HOP", n2, 0, 0, 0, 0, this.lex.getCurrPane(), this.lex.getRelativeLine());
        } else if (n.equals(TOSS)) {
            this.genCode("TOSS", 0, 0, 0, 0, 0, this.lex.getCurrPane(), this.lex.getRelativeLine());
        } else if (n.equals(PICK)) {
            this.genCode("PICK", 0, 0, 0, 0, 0, this.lex.getCurrPane(), this.lex.getRelativeLine());
        } else if (n.equals(PLANT)) {
            this.genCode("PLANT", 0, 0, 0, 0, 0, this.lex.getCurrPane(), this.lex.getRelativeLine());
        } else if (n.equals(GIVE)) {
            this.sym = this.lex.getSym();
            int n3 = this.sdirection();
            this.genCode("GIVE", n3, 0, 0, 0, 0, this.lex.getCurrPane(), this.lex.getRelativeLine());
        } else if (n.equals(TURN)) {
            this.sym = this.lex.getSym();
            int n4 = this.sdirection();
            this.genCode("TURN", n4, 0, 0, 0, 0, this.lex.getCurrPane(), this.lex.getRelativeLine());
        }
        this.sym = this.lex.getSym();
        if (!this.sym.equals(RPAREN)) {
            this.error(4);
        }
        this.sym = this.lex.getSym();
    }

    protected void methodCall() throws IOException, CompileException {
        SymbolTableEntry symbolTableEntry = this.symTab.findEntry(this.lex.getLastIdentifier());
        if (symbolTableEntry == null) {
            this.error(12);
        }
        if (symbolTableEntry.getType().equals("method")) {
            MethodEntry methodEntry = (MethodEntry)symbolTableEntry;
            int n = methodEntry.getAddress();
            this.genCode("CALLBK", 0, 0, 0, 0, 0, this.lex.getCurrPane(), this.lex.getRelativeLine());
            this.genCode("JUMP", n, 0, 0, 0, 0, this.lex.getCurrPane(), this.lex.getRelativeLine());
            if (methodEntry.getAddress() == -999) {
                this.jumpLabels.add(new JumpAssociation(this.codeIndex - 1, methodEntry.getName()));
            }
            this.sym = this.lex.getSym();
            if (!this.sym.equals(LPAREN)) {
                this.error(3);
            }
            this.sym = this.lex.getSym();
            if (!this.sym.equals(RPAREN)) {
                this.error(4);
            }
            this.sym = this.lex.getSym();
        } else {
            this.error(11);
        }
    }

    protected void boolexpr(String string, int n, int n2) throws IOException, CompileException {
        this.boolterm(string, n, n2);
        while (this.sym.equals(ORSYM)) {
            this.sym = this.lex.getSym();
            this.boolterm(string, n, n2);
            this.genCode("OR", 0, 0, 0, 0, 0, n, n2);
        }
    }

    protected void boolterm(String string, int n, int n2) throws IOException, CompileException {
        this.boolfactor(string, n, n2);
        while (this.sym.equals(ANDSYM)) {
            this.sym = this.lex.getSym();
            this.boolfactor(string, n, n2);
            this.genCode("AND", 0, 0, 0, 0, 0, n, n2);
        }
    }

    protected void boolfactor(String string, int n, int n2) throws IOException, CompileException {
        if (this.sym.equals(LPAREN)) {
            this.sym = this.lex.getSym();
            this.boolexpr(string, n, n2);
            if (!this.sym.equals(RPAREN)) {
                this.error(4);
            }
            this.sym = this.lex.getSym();
        } else if (this.sym.equals(NOTSYM)) {
            this.sym = this.lex.getSym();
            this.boolfactor(string, n, n2);
            this.genCode("NOT", 0, 0, 0, 0, 0, n, n2);
        } else {
            this.boolsensor(string, n, n2);
        }
    }

    protected void boolsensor(String string, int n, int n2) throws IOException, CompileException {
        if (string.equals("METHOD") && this.sym.equals(IDENT)) {
            this.error(8);
        }
        if (string.equals("MAIN")) {
            if (!this.sym.equals(IDENT)) {
                this.error(20);
            }
            this.jerooInstance(n, n2);
            this.sym = this.lex.getSym();
            if (!this.sym.equals(MEMBERSELECT)) {
                this.error(22);
            }
            this.sym = this.lex.getSym();
        }
        Integer n3 = this.sym;
        this.sym = this.lex.getSym();
        if (!this.sym.equals(LPAREN)) {
            this.error(3);
        }
        if (n3.equals(HASFLWR)) {
            this.genCode("HASFLWR", 0, 0, 0, 0, 0, n, n2);
        } else if (n3.equals(ISFLWR)) {
            this.sym = this.lex.getSym();
            int n4 = this.sdirection();
            this.genCode("ISFLWR", n4, 0, 0, 0, 0, n, n2);
        } else if (n3.equals(ISNET)) {
            this.sym = this.lex.getSym();
            int n5 = this.sdirection();
            this.genCode("ISNET", n5, 0, 0, 0, 0, n, n2);
        } else if (n3.equals(ISWATER)) {
            this.sym = this.lex.getSym();
            int n6 = this.sdirection();
            this.genCode("ISWATER", n6, 0, 0, 0, 0, n, n2);
        } else if (n3.equals(ISJEROO)) {
            this.sym = this.lex.getSym();
            int n7 = this.sdirection();
            this.genCode("ISJEROO", n7, 0, 0, 0, 0, n, n2);
        } else if (n3.equals(FACING)) {
            this.sym = this.lex.getSym();
            int n8 = this.cdirection();
            this.genCode("FACING", n8, 0, 0, 0, 0, n, n2);
        } else if (n3.equals(ISCLEAR)) {
            this.sym = this.lex.getSym();
            int n9 = this.sdirection();
            this.genCode("ISJEROO", n9, 0, 0, 0, 0, n, n2);
            this.genCode("ISWATER", n9, 0, 0, 0, 0, n, n2);
            this.genCode("ISNET", n9, 0, 0, 0, 0, n, n2);
            this.genCode("ISFLWR", n9, 0, 0, 0, 0, n, n2);
            this.genCode("OR", 0, 0, 0, 0, 0, n, n2);
            this.genCode("OR", 0, 0, 0, 0, 0, n, n2);
            this.genCode("OR", 0, 0, 0, 0, 0, n, n2);
            this.genCode("NOT", 0, 0, 0, 0, 0, n, n2);
        } else {
            this.error(8);
        }
        this.sym = this.lex.getSym();
        if (!this.sym.equals(RPAREN)) {
            this.error(4);
        }
        this.sym = this.lex.getSym();
    }

    protected int sdirection() throws CompileException {
        if (this.sym.equals(RIGHT)) {
            return 1;
        }
        if (this.sym.equals(LEFT)) {
            return 3;
        }
        if (this.sym.equals(AHEAD)) {
            return 0;
        }
        if (this.sym.equals(HERE)) {
            return -1;
        }
        this.error(9);
        return 5;
    }

    protected int cdirection() throws CompileException {
        if (this.sym.equals(NORTH)) {
            return 0;
        }
        if (this.sym.equals(EAST)) {
            return 1;
        }
        if (this.sym.equals(SOUTH)) {
            return 2;
        }
        if (this.sym.equals(WEST)) {
            return 3;
        }
        this.error(10);
        return 5;
    }

    protected void updateJumpLocations() {
        for (int i = 0; i < this.jumpLabels.size(); ++i) {
            JumpAssociation jumpAssociation = (JumpAssociation)this.jumpLabels.elementAt(i);
            Instruction instruction = (Instruction)this.code.elementAt(jumpAssociation.index);
            MethodEntry methodEntry = (MethodEntry)this.symTab.findEntry(jumpAssociation.identifier);
            instruction.arg1 = methodEntry.getAddress();
        }
    }

    protected void genCode(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.code.addElement(new Instruction(string, n, n2, n3, n4, n5, n6, n7));
        ++this.codeIndex;
    }

    protected void error(int n) throws CompileException {
        String[] stringArray = new String[]{"Method separator expected.", "End-of-file expected.", "Identifier expected.\n               Found \"XX\" instead.", "Missing left parenthesis.\n               Check this line and previous line.", "Missing right (or extra left) parenthesis.\n               Check this line and previous line.", "Left brace expected.", "Missing right (or extra left) brace.", "Missing semicolon.  Check previous line.", "Boolean (sensor) method expected.\n               Found \"XX\" instead.", "Relative direction expected.\n               Found \"XX\" instead.", "Compass direction expected.\n               Found \"XX\" instead.", "Illegal statement.", "Unknown identifier \"XX\".\n               Check spelling and capitalization.", "Keyword \"method\" expected.\n               Found \"XX\" instead.", "Assignment operator (=) expected.", "\"new\" operator expected.\n               Found \"XX\" instead.", "Jeroo class name expected.\n               Found \"XX\" instead.", "Comma expected.", "Integer expected.\n               Found \"XX\" instead.", "Too many Jeroo instances.", "Identifier expected.\n               Found \"XX\" instead.", "Jeroo identifer expected.", "Period expected.\n               Check this line and previous line.", "Duplicate identifier \"XX\" for a Jeroo or method.", "Keyword \"main\" expected.\n               Found \"XX\" instead.", "Unknown constructor argument: \"XX\".", "Invalid Statement: \n               Excess punctuation?  \n               Missing keyword \"End\"? ", "Keyword \"Sub\" expected.\n               Found \"XX\" instead.", "This is not a valid VB.NET style file.\n               Try saving it and recompiling.", "Keyword \"As\" expected.\n               Found \"XX\" instead.", "keyword \"If\" expected after \"end\".\n               Check this line or previous \"end\".", "Keyword \"While\" expected after \"end\".\n               Check this line or previous \"end\".", "Keyword \"Then\" expected.\n               Found \"XX\" instead.", "This is not a valid Java/C++/C# style file.\n               Try saving it and recompiling.", "Method invocation expected.\n               Found \"XX\" instead.", "Colon expected.  Check previous line.", "Keyword \"self\" expected.", "This is not a valid Python style file.\n               Try saving it and recompiling.", "Keyword \"def\" expected.\n               Found \"XX\" instead.", "Check this and previous line: \n               Excess punctuation?  \n               Inconsistent Indentation? \n               Missing \"def\"? ", "Invalid Statement or Missing End-of-File: \n               Check for excess punctuation or\n               excess indentation.", "Unbound identifier in method body: \n               Missing \"self\"? \n               Excess puncutation?  \n               Extra text at end of line? "};
        SourceLineReference sourceLineReference = new SourceLineReference(this.lex.getCurrPane(), this.lex.getRelativeLine());
        String string = stringArray[n].replaceAll("XX", this.lex.getLastSourceWord());
        this.lex.closeFile();
        throw new CompileException("SYNTAX ERROR:  " + string, sourceLineReference);
    }

    protected void writeObjectFile(String string) throws IOException {
        this.out = new BufferedWriter(new FileWriter(string));
        for (int i = 0; i < this.code.size(); ++i) {
            this.out.write(((Instruction)this.code.elementAt(i)).toString());
            this.out.newLine();
        }
        this.out.flush();
        this.out.close();
    }

    public void reset() {
        this.symTab.clear();
        this.jumpLabels.clear();
        this.nameTab.clear();
        this.instanceCount = 0;
        this.currentJeroo = -1;
        this.code.clear();
        this.codeIndex = 0;
    }
}

