/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontSelector
extends JDialog
implements ActionListener,
ListSelectionListener {
    protected final String SAMPLE_TEXT = "Jeroo is Cool";
    protected final String USE_CMD = "Use";
    protected final String USE_AND_SAVE_CMD = "Save";
    protected final String CANCEL_CMD = "Cancel";
    protected Container contentPane;
    protected JPanel selectionPanel = new JPanel();
    protected JPanel samplePanel = new JPanel();
    protected JPanel buttonPanel = new JPanel();
    protected JPanel fontFamilyPanel = new JPanel();
    protected JPanel fontStylePanel = new JPanel();
    protected JPanel fontSizePanel = new JPanel();
    protected JPanel styleButtonPanel = new JPanel();
    protected JScrollPane fontFamilyPane = new JScrollPane();
    protected JScrollPane fontSizePane = new JScrollPane();
    protected JList fontFamilyList;
    protected JList fontSizeList;
    protected StyleButton[] styleButtons = new StyleButton[]{new StyleButton("Plain", 0), new StyleButton("Bold", 1)};
    protected ButtonGroup styleGroup = new ButtonGroup();
    protected JButton useButton = new JButton("Use This Font");
    protected JButton saveButton = new JButton("Use & Set As Default");
    protected JButton cancelButton = new JButton("Cancel");
    protected JLabel fontFamilyLabel = new JLabel("Font Name");
    protected JLabel fontStyleLabel = new JLabel("Font Style");
    protected JLabel fontSizeLabel = new JLabel("Font Size");
    protected JLabel sampleLabel = new JLabel("   Sample Text");
    protected JTextField sampleField = new JTextField();
    protected String[] fontFamilies;
    protected String[] fontSizes = new String[]{"12", "14", "16", "18", "20", "24"};
    protected Font startingFont;
    protected Font selectedFont = null;
    protected String selectedFamily;
    protected int selectedStyle;
    protected int selectedSize;
    boolean fontChanged;
    boolean saveRequested;

    public FontSelector(Font font) {
        super((Frame)null, "Font Selection Dialog", true);
        int n;
        this.startingFont = font;
        this.selectedFont = font;
        this.selectedFamily = font.getFamily();
        this.selectedStyle = font.getStyle();
        this.selectedSize = font.getSize();
        this.fontChanged = false;
        this.saveRequested = false;
        for (n = 0; n < this.styleButtons.length; ++n) {
            this.styleGroup.add(this.styleButtons[n]);
            this.styleButtons[n].addActionListener(this);
        }
        int n2 = font.getStyle();
        for (n = 0; n < this.styleButtons.length; ++n) {
            if (n2 != this.styleButtons[n].getFontStyle()) continue;
            this.styleButtons[n].setSelected(true);
            break;
        }
        this.styleButtonPanel.setLayout(new BoxLayout(this.styleButtonPanel, 1));
        for (n = 0; n < this.styleButtons.length; ++n) {
            this.styleButtonPanel.add(this.styleButtons[n]);
        }
        this.styleButtonPanel.setBorder(new CompoundBorder(BorderFactory.createBevelBorder(1), new EmptyBorder(5, 5, 5, 5)));
        this.fontStylePanel = new JPanel(new BorderLayout());
        this.fontStylePanel.add((Component)this.fontStyleLabel, "North");
        this.fontStylePanel.add((Component)this.styleButtonPanel, "Center");
        this.fontSizeList = new JList<String>(this.fontSizes);
        this.fontSizeList.setSelectionMode(0);
        this.fontSizeList.setVisibleRowCount(6);
        this.fontSizeList.addListSelectionListener(this);
        this.fontSizePane.getViewport().add(this.fontSizeList);
        String string = Integer.toString(font.getSize());
        this.fontSizeList.setSelectedValue(string, true);
        this.fontSizePanel = new JPanel(new BorderLayout());
        this.fontSizePanel.add((Component)this.fontSizeLabel, "North");
        this.fontSizePanel.add((Component)this.fontSizePane, "Center");
        this.selectionPanel.add(this.fontStylePanel);
        this.selectionPanel.add(Box.createHorizontalStrut(30));
        this.selectionPanel.add(this.fontSizePanel);
        this.sampleField.setSize(JerooConstants.FONT_SELECTOR_DIMENSION);
        this.sampleField.setEditable(false);
        this.sampleField.setBackground(Color.WHITE);
        this.sampleField.setHorizontalAlignment(0);
        this.sampleField.setBorder(BorderFactory.createLoweredBevelBorder());
        this.sampleField.setFont(this.selectedFont);
        this.sampleField.setText("Jeroo is Cool");
        this.sampleLabel.setVerticalAlignment(3);
        this.samplePanel.setLayout(new BorderLayout());
        this.samplePanel.add(Box.createRigidArea(new Dimension(400, 5)), "North");
        this.samplePanel.add((Component)this.sampleLabel, "South");
        this.samplePanel.add((Component)this.sampleField, "Center");
        this.samplePanel.add(Box.createRigidArea(new Dimension(5, 60)), "West");
        this.samplePanel.add(Box.createRigidArea(new Dimension(5, 60)), "East");
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.useButton.setToolTipText("Use this font for the current document");
        this.useButton.setActionCommand("Use");
        this.saveButton.setToolTipText("Make this the default font, and use it for the current document");
        this.saveButton.setActionCommand("Save");
        this.cancelButton.setToolTipText("Do not change the font");
        this.cancelButton.setActionCommand("Cancel");
        this.buttonPanel.add(this.useButton);
        this.buttonPanel.add(this.saveButton);
        this.buttonPanel.add(this.cancelButton);
        this.useButton.addActionListener(this);
        this.saveButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.contentPane = this.getContentPane();
        this.contentPane.add((Component)this.selectionPanel, "North");
        this.contentPane.add((Component)this.samplePanel, "Center");
        this.contentPane.add((Component)this.buttonPanel, "South");
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(null);
    }

    public int find(String[] stringArray, String string) {
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    public boolean fontChanged() {
        return this.fontChanged;
    }

    public Font getSelectedFont() {
        return this.selectedFont;
    }

    public boolean saveRequested() {
        return this.saveRequested;
    }

    private void updateFont() {
        this.selectedFont = new Font(this.selectedFamily, this.selectedStyle, this.selectedSize);
        this.sampleField.setFont(this.selectedFont);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Plain")) {
            this.selectedStyle = 0;
            this.updateFont();
        } else if (string.equals("Bold")) {
            this.selectedStyle = 1;
            this.updateFont();
        } else if (string.equals("Italic")) {
            this.selectedStyle = 2;
            this.updateFont();
        } else if (string.equals("Bold Italic")) {
            this.selectedStyle = 3;
            this.updateFont();
        } else if (string.equals("Use")) {
            this.fontChanged = !this.selectedFont.equals(this.startingFont);
            this.setVisible(false);
        } else if (string.equals("Save")) {
            this.fontChanged = !this.selectedFont.equals(this.startingFont);
            this.saveRequested = true;
            this.setVisible(false);
        } else if (string.equals("Cancel")) {
            this.selectedFont = this.startingFont;
            this.fontChanged = false;
            this.setVisible(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            if (listSelectionEvent.getSource() == this.fontFamilyList) {
                this.selectedFamily = (String)this.fontFamilyList.getSelectedValue();
            } else if (listSelectionEvent.getSource() == this.fontSizeList) {
                String string = (String)this.fontSizeList.getSelectedValue();
                this.selectedSize = Integer.parseInt(string);
            }
            this.updateFont();
        }
    }

    private class StyleButton
    extends JRadioButton {
        String name;
        int fontStyle;

        private StyleButton(String string, int n) {
            super(string);
            this.name = string;
            this.fontStyle = n;
        }

        private int getFontStyle() {
            return this.fontStyle;
        }
    }
}

