/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.StreamTokenizer;

public class InstructionMemory {
    private int maxWords = 1000;
    private int currentWords = 0;
    private Instruction[] word = new Instruction[this.maxWords];

    public InstructionMemory(String string) throws Exception {
        this.loadProgram(string);
    }

    public Instruction getInstruction(int n) throws Exception {
        if (0 > n || n >= this.currentWords) {
            throw new JerooException("Processor Error: Attempt to fetch instruction at illegal address");
        }
        return this.word[n];
    }

    public void loadProgram(String string) throws Exception {
        StreamTokenizer streamTokenizer = new StreamTokenizer(new BufferedReader(new FileReader(string)));
        boolean bl = false;
        while (!bl) {
            if (streamTokenizer.nextToken() == -1) {
                bl = true;
                continue;
            }
            String string2 = streamTokenizer.sval.toUpperCase();
            streamTokenizer.nextToken();
            int n = (int)streamTokenizer.nval;
            streamTokenizer.nextToken();
            int n2 = (int)streamTokenizer.nval;
            streamTokenizer.nextToken();
            int n3 = (int)streamTokenizer.nval;
            streamTokenizer.nextToken();
            int n4 = (int)streamTokenizer.nval;
            streamTokenizer.nextToken();
            int n5 = (int)streamTokenizer.nval;
            streamTokenizer.nextToken();
            int n6 = (int)streamTokenizer.nval;
            streamTokenizer.nextToken();
            int n7 = (int)streamTokenizer.nval;
            if (this.currentWords >= this.maxWords) {
                throw new JerooException("Processor Error: Program too large for instruction memory");
            }
            this.word[this.currentWords++] = new Instruction(string2, n, n2, n3, n4, n5, n6, n7);
        }
    }

    public void dumpMemory() {
        for (int i = 0; i < this.currentWords; ++i) {
            System.out.println("" + i + ": " + this.word[i].toString());
        }
    }
}

