/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileNotFoundException;

public class JavaLexicalAnalyzer
extends LexicalAnalyzer {
    public JavaLexicalAnalyzer(String string, String string2) throws FileNotFoundException {
        super(string, string2);
        this.caseSensitive = true;
    }

    @Override
    protected boolean isValidIdentifier(String string) {
        boolean bl = Character.isJavaIdentifierStart(string.charAt(0));
        for (int i = 1; i < string.length(); ++i) {
            bl = bl && Character.isJavaIdentifierPart(string.charAt(i));
        }
        return bl;
    }

    @Override
    protected void addReservedWords() {
        this.rwSymbols.put("main", MAINSYM);
        this.rwSymbols.put("method", METHODSYM);
        this.rwSymbols.put("&&", ANDSYM);
        this.rwSymbols.put("||", ORSYM);
    }

    @Override
    protected void addSymbols() {
        this.chSymbols.put(new Character(';'), SEMICOLON);
        this.chSymbols.put(new Character('{'), LBRACE);
        this.chSymbols.put(new Character('}'), RBRACE);
        this.chSymbols.put(new Character('!'), NOTSYM);
    }

    @Override
    protected void configureStreamTokenizer() {
        this.tokenizer.eolIsSignificant(true);
        this.tokenizer.slashSlashComments(true);
        this.tokenizer.slashStarComments(false);
        this.tokenizer.ordinaryChar(46);
        this.tokenizer.ordinaryChar(47);
        this.tokenizer.wordChars(64, 64);
        this.tokenizer.wordChars(36, 36);
        this.tokenizer.wordChars(95, 95);
        this.tokenizer.wordChars(38, 38);
        this.tokenizer.wordChars(124, 124);
    }
}

