/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class Jeroo
extends JComponent {
    private ImageIcon[] icons;
    private SantongModel theModel;
    private String name;
    private Point location;
    private long flowers;
    private int direction;
    private boolean inWater = false;
    private boolean inNet = false;
    private boolean onJeroo = false;

    public Jeroo(SantongModel santongModel, String string, ImageIcon[] imageIconArray, Point point, long l, int n) throws Exception {
        IslandComponent islandComponent = null;
        if (l < 0L) {
            throw new JerooException("INSTANTIATION ERROR:  flowers < 0");
        }
        if (n < 0 || n > 3) {
            throw new JerooException("INSTANTIATION ERROR:  The direction is invalid");
        }
        if (!santongModel.hasIslandLocation(point)) {
            throw new JerooException("INSTANTIATION ERROR: \"" + string + "\" started in the ocean");
        }
        islandComponent = (IslandComponent)santongModel.componentAt(point);
        if (islandComponent != null && islandComponent.hasNet()) {
            this.inNet = true;
            islandComponent.addJeroo(this);
            throw new JerooException("INSTANTIATION ERROR: \"" + string + "\" started in a net");
        }
        if (islandComponent != null && islandComponent.hasWater()) {
            this.inWater = true;
            islandComponent.addJeroo(this);
            throw new JerooException("INSTANTIATION ERROR: \"" + string + "\" started in the water");
        }
        if (islandComponent != null && islandComponent.hasJeroo()) {
            this.onJeroo = true;
            String string2 = islandComponent.getJeroo().getName();
            islandComponent.addJeroo(this);
            throw new JerooException("INSTANTIATION ERROR: \"" + string2 + "\" is already there");
        }
        this.theModel = santongModel;
        this.name = string;
        this.icons = imageIconArray;
        this.location = point;
        this.flowers = l;
        this.direction = n;
        santongModel.componentAt(point).addJeroo(this);
        JerooStatusPanel jerooStatusPanel = JerooStatusPanel.getInstance();
        jerooStatusPanel.addJeroo(this);
    }

    public long getFlowers() {
        return this.flowers;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ImageIcon getIcon() {
        if (this.inWater) {
            return JerooIcons.wetJerooIcon;
        }
        if (this.inNet) {
            return JerooIcons.trappedJerooIcon;
        }
        if (this.onJeroo) {
            return JerooIcons.collisionIcon;
        }
        if (((IslandComponent)this.theModel.componentAt(this.location)).hasFlower()) {
            return this.icons[this.direction + 4];
        }
        return this.icons[this.direction];
    }

    public void hop() throws Exception {
        SantongComponent santongComponent = null;
        IslandComponent islandComponent = null;
        Point point = this.getLocation(0);
        santongComponent = this.theModel.componentAt(point);
        if (santongComponent instanceof OceanComponent) {
            this.inWater = true;
            this.theModel.componentAt(this.location).removeJeroo();
            santongComponent.addJeroo(this);
            throw new JerooException("LOGIC ERROR: \"" + this.name + "\" hopped into the water");
        }
        islandComponent = (IslandComponent)santongComponent;
        if (islandComponent.hasNet()) {
            this.inNet = true;
            this.theModel.componentAt(this.location).removeJeroo();
            this.theModel.componentAt(point).addJeroo(this);
            throw new JerooException("LOGIC ERROR: \"" + this.name + "\" is trapped in a net");
        }
        if (islandComponent.hasWater()) {
            this.inWater = true;
            this.theModel.componentAt(this.location).removeJeroo();
            this.theModel.componentAt(point).addJeroo(this);
            throw new JerooException("LOGIC ERROR: \"" + this.name + "\" hopped into the water");
        }
        if (islandComponent.hasJeroo()) {
            this.onJeroo = true;
            String string = islandComponent.getJeroo().getName();
            this.theModel.componentAt(this.location).removeJeroo();
            this.theModel.componentAt(point).addJeroo(this);
            throw new JerooException("LOGIC ERROR: \"" + this.name + "\" collided with \"" + string + "\"");
        }
        this.theModel.componentAt(this.location).removeJeroo();
        this.location = point;
        this.theModel.componentAt(this.location).addJeroo(this);
        if (((IslandComponent)this.theModel.componentAt(this.location)).hasFlower()) {
            // empty if block
        }
        this.firePropertyChange("Jeroo Property", 0, 1);
    }

    public void turn(int n) {
        if (n > 0) {
            int n2 = this.direction;
            this.direction = (this.direction + n) % 4;
            IslandComponent islandComponent = (IslandComponent)this.theModel.componentAt(this.location);
            islandComponent.repaint();
            this.firePropertyChange("Jeroo Property", n2, this.direction);
        }
    }

    public void plant() {
        if (this.flowers > 0L) {
            IslandComponent islandComponent = (IslandComponent)this.theModel.componentAt(this.location);
            islandComponent.addFlower();
            --this.flowers;
            this.firePropertyChange("Jeroo Property", this.flowers + 1L, this.flowers);
        }
    }

    public void toss() {
        if (this.flowers > 0L) {
            --this.flowers;
            if (this.isNet(0)) {
                Point point = this.getLocation(0);
                IslandComponent islandComponent = (IslandComponent)this.theModel.componentAt(point);
                islandComponent.removeNet();
            }
            this.firePropertyChange("Jeroo Property", this.flowers + 1L, this.flowers);
        }
    }

    public void pick() {
        IslandComponent islandComponent = (IslandComponent)this.theModel.componentAt(this.location);
        if (islandComponent.hasFlower()) {
            islandComponent.removeFlower();
            ++this.flowers;
            this.firePropertyChange("Jeroo Property", this.flowers - 1L, this.flowers);
        }
    }

    public void acceptFlower() {
        ++this.flowers;
        this.firePropertyChange("Jeroo Property", this.flowers - 1L, this.flowers);
    }

    public void give(int n) {
        SantongComponent santongComponent;
        if (this.flowers > 0L && (santongComponent = this.componentOn(n)) instanceof IslandComponent && (santongComponent = (IslandComponent)santongComponent).hasJeroo()) {
            --this.flowers;
            santongComponent.getJeroo().acceptFlower();
            this.firePropertyChange("Jeroo Property", this.flowers + 1L, this.flowers);
        }
    }

    public boolean hasFlower() {
        return this.flowers > 0L;
    }

    public boolean isFlower(int n) {
        SantongComponent santongComponent = this.componentOn(n);
        return santongComponent instanceof IslandComponent && ((IslandComponent)santongComponent).hasFlower();
    }

    public boolean isJeroo(int n) {
        SantongComponent santongComponent = this.componentOn(n);
        return santongComponent instanceof IslandComponent && ((IslandComponent)santongComponent).hasJeroo();
    }

    public boolean isWater(int n) {
        SantongComponent santongComponent = this.componentOn(n);
        return santongComponent instanceof OceanComponent || santongComponent instanceof IslandComponent && ((IslandComponent)santongComponent).hasWater();
    }

    public boolean isFacing(int n) {
        return this.direction == n;
    }

    public boolean isNet(int n) {
        SantongComponent santongComponent = this.componentOn(n);
        return santongComponent instanceof IslandComponent && ((IslandComponent)santongComponent).hasNet();
    }

    private Point getLocation(int n) {
        int n2 = (this.direction + n) % 4;
        int n3 = (int)JerooConstants.STEP[n2].getX();
        int n4 = (int)JerooConstants.STEP[n2].getY();
        Point point = this.location.getLocation();
        point.translate(n3, n4);
        return point;
    }

    private SantongComponent componentOn(int n) {
        Point point = n == 3 ? this.getLocation(3) : (n == 1 ? this.getLocation(1) : (n == -1 ? this.location : this.getLocation(0)));
        return this.theModel.componentAt(point);
    }

    public SantongComponent getComponent() {
        return this.theModel.componentAt(this.location);
    }
}

