/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.border.BevelBorder;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class JerooGUI
extends JFrame
implements PropertyChangeListener,
ActionListener {
    private Container guiPane;
    private JMenuBar menuBar = new JMenuBar();
    private JerooToolBar toolBar = new JerooToolBar();
    private JerooSourceArea mainSourceArea = new JerooSourceArea(15, 53);
    private JerooSourceArea methodSourceArea = new JerooSourceArea(15, 53);
    private JerooSourceTabs sourceTabPane = new JerooSourceTabs(this.mainSourceArea, this.methodSourceArea);
    private SantongModel santongModel = new SantongModel();
    private SantongView santongView = new SantongView(this.santongModel, 364, 364);
    private JerooStatusPanel statusPanel = JerooStatusPanel.getInstance();
    private JerooMenu sourceFileMenu = new JerooMenu("Source File");
    private JerooMenu sourceEditMenu = new JerooMenu("Source Edit");
    private JerooMenu runMenu = new JerooMenu("Run");
    private JerooMenu envFileMenu = new JerooMenu("Island File");
    private JerooMenu envEditMenu = new JerooMenu("Island Edit");
    private JerooMenu helpMenu = new JerooMenu("Help");
    private JMenuItem jerooHomeItem = new JMenuItem("Jeroo Homepage");
    private JMenuItem tutorialItem = new JMenuItem("Getting Started Tutorial");
    private JMenuItem aboutItem = new JMenuItem("About Jeroo");
    private JMenuItem awardsItem = new JMenuItem("Awards Received");
    private JMenuItem historyItem = new JMenuItem("Jeroo's History");
    private JMenuItem copyrightItem = new JMenuItem("Copyright Notice");
    private JerooControl newSourceControl;
    private JerooControl openSourceControl;
    private JerooControl saveSourceControl;
    private JerooControl saveAsSourceControl;
    private JerooControl printSourceControl;
    private JerooTextControl cutControl;
    private JerooTextControl copyControl;
    private JerooTextControl pasteControl;
    private SourceUndoControl undoControl;
    private SourceUndoControl redoControl;
    private JerooTextControl indentControl;
    private JerooTextControl unindentControl;
    private JerooTextControl commentControl;
    private JerooTextControl uncommentControl;
    private JerooControl preferencesControl;
    private JerooControl fontControl;
    private JerooControl resetControl;
    private JerooControl stepControl;
    private JerooControl runControl;
    private JerooControl pauseRunControl;
    private JerooControl stopRunControl;
    private JerooSpeedControl speedControl;
    private JerooControl newEnvControl;
    private JerooControl openEnvControl;
    private JerooControl saveEnvControl;
    private JerooControl saveAsEnvControl;
    private JerooControl printEnvControl;
    private JerooControl addFlowerControl;
    private JerooControl addNetControl;
    private JerooControl addWaterControl;
    private JerooControl clearEnvControl;
    private JerooControl helpControl;
    private JerooControl exitControl;
    Cursor noEnvEditCursor;
    Cursor flowerCursor;
    Cursor netCursor;
    Cursor waterCursor;
    Cursor savedCursor;
    Compiler jerooCompiler;
    Processor jerooProcessor;
    RunThread executionThread = null;
    private SourceUndoManager undoMgr = SourceUndoManager.getInstance();
    private JerooFlagManager flagMgr = JerooFlagManager.getInstance();
    private JerooReporter reporter = new JerooReporter();
    private JavaLanguageSummaryFrame javaHelpFrame = new JavaLanguageSummaryFrame();
    private VBLanguageSummaryFrame vbHelpFrame = new VBLanguageSummaryFrame();
    private PythonLanguageSummaryFrame pythonHelpFrame = new PythonLanguageSummaryFrame();
    private LanguageStylePanel stylePanel = LanguageStylePanel.getInstance();
    private LanguageStyleManager styleMgr = LanguageStyleManager.getInstance();
    private File currentSourceFile = null;
    private File currentEnvFile = null;
    private File currentObjectFile = null;
    private File fileToOpen = null;
    private String sourceFilePath = null;
    private String envFilePath = null;
    private String objectFilePath = null;
    private String printID;
    private boolean running = false;
    private boolean paused = false;
    private boolean windowClosing = false;
    private RecentFileManager recentFileMgr;
    private JMenuItem[] recentSourceFiles;
    private JMenuItem[] recentIslandFiles;
    private UserPreferences userPrefs;
    private Font sourceFont = JerooConstants.DEFAULT_SOURCE_FONT;

    public JerooGUI() {
        int n;
        this.setSize(JerooConstants.SMALL_GUI_DIMENSION);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.updateTitle();
        this.userPrefs = UserPreferences.getInstance();
        this.recentFileMgr = new RecentFileManager(this.userPrefs.getSourceNames(), this.userPrefs.getIslandNames());
        this.guiPane = this.getContentPane();
        this.guiPane.setLayout(new BorderLayout());
        this.createControls();
        this.createCursors();
        this.setJMenuBar(this.menuBar);
        this.menuBar.add(this.sourceFileMenu);
        this.menuBar.add(Box.createHorizontalStrut(56));
        this.menuBar.add(this.sourceEditMenu);
        this.menuBar.add(Box.createHorizontalStrut(55));
        this.menuBar.add(this.runMenu);
        this.menuBar.add(Box.createHorizontalStrut(92));
        this.menuBar.add(this.speedControl.getMenu());
        this.menuBar.add(Box.createHorizontalStrut(36));
        this.menuBar.add(this.envFileMenu);
        this.menuBar.add(Box.createHorizontalStrut(60));
        this.menuBar.add(this.envEditMenu);
        this.menuBar.add(Box.createHorizontalStrut(36));
        this.menuBar.add(this.helpMenu);
        this.sourceFileMenu.setMnemonic(70);
        this.sourceFileMenu.addJerooControl(this.newSourceControl);
        this.sourceFileMenu.addJerooControl(this.openSourceControl);
        this.sourceFileMenu.addSeparator();
        this.sourceFileMenu.addJerooControl(this.saveSourceControl);
        this.sourceFileMenu.addJerooControl(this.saveAsSourceControl);
        this.sourceFileMenu.addSeparator();
        this.sourceFileMenu.addJerooControl(this.printSourceControl);
        this.sourceFileMenu.addSeparator();
        this.recentSourceFiles = this.recentFileMgr.getSourceItems();
        for (n = 0; n < this.recentSourceFiles.length; ++n) {
            this.sourceFileMenu.add(this.recentSourceFiles[n]);
            this.recentSourceFiles[n].addActionListener(this);
        }
        this.sourceFileMenu.addSeparator();
        this.sourceFileMenu.addJerooControl(this.exitControl);
        this.sourceEditMenu.setMnemonic(69);
        this.sourceEditMenu.addJerooControl(this.cutControl);
        this.sourceEditMenu.addJerooControl(this.copyControl);
        this.sourceEditMenu.addJerooControl(this.pasteControl);
        this.sourceEditMenu.addSeparator();
        this.sourceEditMenu.addJerooControl(this.undoControl);
        this.sourceEditMenu.addJerooControl(this.redoControl);
        this.sourceEditMenu.addSeparator();
        this.sourceEditMenu.addJerooControl(this.commentControl);
        this.sourceEditMenu.addJerooControl(this.uncommentControl);
        this.sourceEditMenu.addSeparator();
        this.sourceEditMenu.addJerooControl(this.indentControl);
        this.sourceEditMenu.addJerooControl(this.unindentControl);
        this.sourceEditMenu.addSeparator();
        this.sourceEditMenu.addJerooControl(this.preferencesControl);
        this.sourceEditMenu.addJerooControl(this.fontControl);
        this.runMenu.setMnemonic(82);
        this.runMenu.addJerooControl(this.resetControl);
        this.runMenu.addJerooControl(this.stepControl);
        this.runMenu.addJerooControl(this.runControl);
        this.runMenu.addJerooControl(this.pauseRunControl);
        this.runMenu.addJerooControl(this.stopRunControl);
        this.speedControl.getMenu().setMnemonic(85);
        this.speedControl.getMenu().addMenuListener(this.santongModel);
        this.envFileMenu.setMnemonic(73);
        this.envFileMenu.addJerooControl(this.newEnvControl);
        this.envFileMenu.addJerooControl(this.openEnvControl);
        this.envFileMenu.addSeparator();
        this.envFileMenu.addJerooControl(this.saveEnvControl);
        this.envFileMenu.addJerooControl(this.saveAsEnvControl);
        this.envFileMenu.addSeparator();
        this.envFileMenu.addJerooControl(this.printEnvControl);
        this.envFileMenu.addSeparator();
        this.recentIslandFiles = this.recentFileMgr.getIslandItems();
        for (n = 0; n < this.recentIslandFiles.length; ++n) {
            this.envFileMenu.add(this.recentIslandFiles[n]);
            this.recentIslandFiles[n].addActionListener(this);
        }
        this.envFileMenu.addMenuListener(this.santongModel);
        this.envEditMenu.setMnemonic(68);
        this.envEditMenu.addJerooControl(this.addFlowerControl);
        this.envEditMenu.addJerooControl(this.addNetControl);
        this.envEditMenu.addJerooControl(this.addWaterControl);
        this.envEditMenu.addJerooControl(this.clearEnvControl);
        this.envEditMenu.addMenuListener(this.santongModel);
        this.helpMenu.setMnemonic(72);
        this.helpMenu.addJerooControl(this.helpControl);
        this.helpMenu.addSeparator();
        this.helpMenu.add(this.tutorialItem);
        this.tutorialItem.setActionCommand("Jeroo Tutorial");
        this.tutorialItem.addActionListener(this);
        this.helpMenu.addSeparator();
        this.helpMenu.add(this.jerooHomeItem);
        this.jerooHomeItem.setActionCommand("Jeroo Home");
        this.jerooHomeItem.addActionListener(this);
        this.helpMenu.addSeparator();
        this.helpMenu.add(this.aboutItem);
        this.aboutItem.setActionCommand("About Jeroo");
        this.aboutItem.addActionListener(this);
        this.helpMenu.add(this.awardsItem);
        this.awardsItem.setActionCommand("Show Awards");
        this.awardsItem.addActionListener(this);
        this.helpMenu.add(this.historyItem);
        this.historyItem.setActionCommand("Jeroo History");
        this.historyItem.addActionListener(this);
        this.helpMenu.add(this.copyrightItem);
        this.copyrightItem.setActionCommand("Show Copyright");
        this.copyrightItem.addActionListener(this);
        this.helpMenu.addMenuListener(this.santongModel);
        this.guiPane.add((Component)this.toolBar, "North");
        this.toolBar.setBackground(Color.DARK_GRAY);
        this.toolBar.setBorder(new BevelBorder(0));
        this.toolBar.addJerooControl(this.newSourceControl);
        this.toolBar.addJerooControl(this.openSourceControl);
        this.toolBar.addJerooControl(this.saveSourceControl);
        this.toolBar.addJerooControl(this.saveAsSourceControl);
        this.toolBar.addJerooControl(this.printSourceControl);
        this.toolBar.addSeparator();
        this.toolBar.addJerooControl(this.cutControl);
        this.toolBar.addJerooControl(this.copyControl);
        this.toolBar.addJerooControl(this.pasteControl);
        this.toolBar.addJerooControl(this.undoControl);
        this.toolBar.addJerooControl(this.redoControl);
        this.toolBar.addSeparator();
        this.toolBar.addJerooControl(this.resetControl);
        this.toolBar.addJerooControl(this.stepControl);
        this.toolBar.addJerooControl(this.runControl);
        this.toolBar.addJerooControl(this.pauseRunControl);
        this.toolBar.addJerooControl(this.stopRunControl);
        this.toolBar.addSeparator();
        this.toolBar.add(this.speedControl.getSlider());
        this.toolBar.addSeparator();
        this.toolBar.addJerooControl(this.newEnvControl);
        this.toolBar.addJerooControl(this.openEnvControl);
        this.toolBar.addJerooControl(this.saveEnvControl);
        this.toolBar.addJerooControl(this.saveAsEnvControl);
        this.toolBar.addJerooControl(this.printEnvControl);
        this.toolBar.addSeparator();
        this.toolBar.addJerooControl(this.addFlowerControl);
        this.toolBar.addJerooControl(this.addNetControl);
        this.toolBar.addJerooControl(this.addWaterControl);
        this.toolBar.addJerooControl(this.clearEnvControl);
        this.toolBar.addSeparator();
        this.toolBar.addJerooControl(this.helpControl);
        this.toolBar.addJerooControl(this.exitControl);
        this.styleMgr.addPropertyChangeListener(this);
        this.stylePanel.setStyle(this.styleMgr.getCurrentStyleCode());
        this.undoControl.setEnabled(false);
        this.redoControl.setEnabled(false);
        this.pauseRunControl.setEnabled(false);
        this.stopRunControl.setEnabled(false);
        this.addFlowerControl.setEnabled(true);
        this.addNetControl.setEnabled(true);
        this.addWaterControl.setEnabled(true);
        this.santongModel.setEditable(true);
        this.addFlowerControl.getButton().doClick();
        this.sourceFont = this.userPrefs.getFont();
        this.guiPane.add((Component)this.sourceTabPane, "West");
        this.sourceTabPane.addSourceUndoListener(new SourceUndoListener(this.undoMgr, this.undoControl, this.redoControl));
        this.sourceTabPane.addSourceMouseListener(new SourceMouseListener());
        this.sourceTabPane.setSourceFont(this.sourceFont);
        this.guiPane.add((Component)this.santongView, "East");
        this.guiPane.add((Component)this.statusPanel, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                JerooGUI.this.windowClosing = true;
                JerooGUI.this.exitControl.getButton().doClick();
            }
        });
        this.pack();
    }

    private void createControls() {
        this.newSourceControl = new JerooControl("New ...", JerooIcons.newSourceIcon, "Create a new source code file", KeyStroke.getKeyStroke(78, 2), 78){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = "Do you want to save your changes to the source code?";
                String string2 = "Unsaved Changes To Source Code";
                String string3 = "Save Changes";
                String string4 = "Discard Changes";
                String string5 = "Cancel \"new\" Operation";
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = JerooGUI.this.santongModel.isEditable();
                if (bl3) {
                    JerooGUI.this.santongModel.setEditable(false);
                }
                if (JerooGUI.this.sourceTabPane.hasUnsavedChanges()) {
                    TwoButtonCancelDialog twoButtonCancelDialog = new TwoButtonCancelDialog(null, string, string2, string3, string4, string5);
                    twoButtonCancelDialog.setVisible(true);
                    String string6 = twoButtonCancelDialog.getValue();
                    twoButtonCancelDialog.dispose();
                    if (string6 != null) {
                        bl = string6.equals(string3);
                        bl2 = string6.equals(string5);
                    } else {
                        bl2 = true;
                    }
                }
                if (bl) {
                    JerooGUI.this.saveSourceControl.getButton().doClick();
                }
                if (!bl2) {
                    JerooGUI.this.currentSourceFile = null;
                    JerooGUI.this.currentObjectFile = null;
                    JerooGUI.this.updatePaths();
                    JerooGUI.this.updateTitle();
                    JerooGUI.this.mainSourceArea.setText("");
                    JerooGUI.this.methodSourceArea.setText("");
                    JerooGUI.this.sourceTabPane.reset();
                    JerooGUI.this.statusPanel.reset();
                    JerooGUI.this.sourceTabPane.clearUnsavedChanges();
                    JerooGUI.this.undoMgr.reset();
                    JerooGUI.this.undoControl.updateUndoRedoStatus();
                    JerooGUI.this.redoControl.updateUndoRedoStatus();
                    JerooGUI.this.styleMgr.setCurrentStyle(JerooGUI.this.styleMgr.getPreferredStyleCode());
                }
                if (bl3) {
                    JerooGUI.this.santongModel.setEditable(true);
                }
            }
        };
        this.openSourceControl = new JerooControl("Open ...", JerooIcons.openSourceIcon, "Open a source code file", KeyStroke.getKeyStroke(79, 2), 79){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                String string = "Do you want to save your changes to the source code?";
                String string2 = "Unsaved Changes To Source Code";
                String string3 = "Save Changes";
                String string4 = "Discard Changes";
                String string5 = "Cancel \"open\" Operation";
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = JerooGUI.this.santongModel.isEditable();
                if (bl4) {
                    JerooGUI.this.santongModel.setEditable(false);
                }
                if (JerooGUI.this.sourceTabPane.hasUnsavedChanges()) {
                    TwoButtonCancelDialog twoButtonCancelDialog = new TwoButtonCancelDialog(null, string, string2, string3, string4, string5);
                    twoButtonCancelDialog.setVisible(true);
                    String string6 = twoButtonCancelDialog.getValue();
                    twoButtonCancelDialog.dispose();
                    if (string6 != null) {
                        bl = string6.equals(string3);
                        bl2 = string6.equals(string5);
                    } else {
                        bl2 = true;
                    }
                }
                if (bl) {
                    JerooGUI.this.saveSourceControl.getButton().doClick();
                }
                if (!bl2) {
                    if (JerooGUI.this.fileToOpen != null) {
                        JerooGUI.this.currentSourceFile = JerooGUI.this.fileToOpen;
                        bl3 = true;
                        JerooGUI.this.fileToOpen = null;
                    } else {
                        jFileChooser.addChoosableFileFilter(new JerooFileFilter("jsc", "Jeroo Source Files (*.jsc)"));
                        jFileChooser.setDialogTitle("Open a Jeroo source code file");
                        jFileChooser.setCurrentDirectory(new File(JerooGUI.this.userPrefs.getPref("LastSourceDirectory")));
                        int n = jFileChooser.showOpenDialog(null);
                        if (n == 0) {
                            JerooGUI.this.currentSourceFile = jFileChooser.getSelectedFile();
                            bl3 = true;
                        } else {
                            bl3 = false;
                        }
                    }
                    if (bl3) {
                        try {
                            JerooGUI.this.sourceTabPane.openFile(JerooGUI.this.currentSourceFile);
                            JerooGUI.this.recentFileMgr.addSourceFile(JerooGUI.this.currentSourceFile.getAbsolutePath());
                            JerooGUI.this.userPrefs.setPref("LastSourceDirectory", JerooGUI.this.currentSourceFile.getParent());
                            JerooGUI.this.currentObjectFile = null;
                            JerooGUI.this.updatePaths();
                            JerooGUI.this.updateTitle();
                            JerooGUI.this.sourceTabPane.reset();
                            JerooGUI.this.statusPanel.reset();
                            JerooGUI.this.undoMgr.reset();
                            JerooGUI.this.undoControl.updateUndoRedoStatus();
                            JerooGUI.this.redoControl.updateUndoRedoStatus();
                        }
                        catch (IOException iOException) {
                            JOptionPane.showMessageDialog(null, "Unable to open or read the file");
                        }
                    }
                }
                if (bl4) {
                    JerooGUI.this.santongModel.setEditable(true);
                }
            }
        };
        this.saveSourceControl = new JerooControl("Save", JerooIcons.saveSourceIcon, "Save the source code to a file", KeyStroke.getKeyStroke(83, 2), 83){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (JerooGUI.this.currentSourceFile == null) {
                    JerooGUI.this.saveAsSourceControl.getButton().doClick();
                } else {
                    try {
                        JerooGUI.this.sourceTabPane.saveToFile(JerooGUI.this.currentSourceFile);
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(null, "Unable to save the file");
                    }
                }
            }
        };
        this.saveAsSourceControl = new JerooControl("Save As ...", JerooIcons.saveAsSourceIcon, "Save the source code to a different file", KeyStroke.getKeyStroke(65, 2), 65){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                boolean bl = JerooGUI.this.santongModel.isEditable();
                if (bl) {
                    JerooGUI.this.santongModel.setEditable(false);
                }
                jFileChooser.addChoosableFileFilter(new JerooFileFilter("jsc", "Jeroo Source Files (*.jsc)"));
                jFileChooser.setDialogTitle("Save a Jeroo source code file");
                jFileChooser.setCurrentDirectory(new File(JerooGUI.this.userPrefs.getPref("LastSourceDirectory")));
                int n = jFileChooser.showSaveDialog(null);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    if (!file.getName().endsWith(".jsc")) {
                        file = new File(file.getPath() + ".jsc");
                    }
                    if (file.exists()) {
                        String string = "File: \"" + file + "\" already exists!";
                        String string2 = "File Replacement Question";
                        String string3 = "Don't Save";
                        String string4 = "Replace It";
                        TwoButtonDialog twoButtonDialog = new TwoButtonDialog(null, string, string2, string3, string4);
                        twoButtonDialog.setVisible(true);
                        boolean bl2 = twoButtonDialog.getValue().equals(string3);
                        twoButtonDialog.dispose();
                        if (bl2) {
                            return;
                        }
                    }
                    JerooGUI.this.currentSourceFile = file;
                    try {
                        JerooGUI.this.sourceTabPane.saveToFile(JerooGUI.this.currentSourceFile);
                        JerooGUI.this.recentFileMgr.addSourceFile(JerooGUI.this.currentSourceFile.getAbsolutePath());
                        JerooGUI.this.userPrefs.setPref("LastSourceDirectory", JerooGUI.this.currentSourceFile.getParent());
                        JerooGUI.this.updatePaths();
                        JerooGUI.this.updateTitle();
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(null, "Unable to save the source file");
                    }
                }
                if (bl) {
                    JerooGUI.this.santongModel.setEditable(true);
                }
            }
        };
        this.printSourceControl = new JerooControl("Print", JerooIcons.printSourceIcon, "Print the source code", KeyStroke.getKeyStroke(80, 2), 80){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrintRangeDialog printRangeDialog = new PrintRangeDialog(JerooGUI.this);
                printRangeDialog.setVisible(true);
                if (printRangeDialog.hasValue()) {
                    String string = printRangeDialog.getValue();
                    if (string == "All") {
                        JerooGUI.this.sourceTabPane.printAll(JerooGUI.this.sourceFilePath, JerooGUI.this.printID);
                    } else if (string == "Main") {
                        JerooGUI.this.sourceTabPane.printMain(JerooGUI.this.sourceFilePath, JerooGUI.this.printID);
                    } else if (string == "Methods") {
                        JerooGUI.this.sourceTabPane.printMethods(JerooGUI.this.sourceFilePath, JerooGUI.this.printID);
                    }
                }
                printRangeDialog.dispose();
            }
        };
        this.cutControl = new JerooTextControl("Cut", JerooIcons.cutIcon, "Cut the selected text and place a copy on the clipboard", KeyStroke.getKeyStroke(88, 2), 84){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JerooSourceArea jerooSourceArea = (JerooSourceArea)this.getFocusedComponent();
                int n = jerooSourceArea.getSelectionStart();
                jerooSourceArea.cutText();
                JerooGUI.this.undoControl.putValue("ShortDescription", "Undo " + JerooGUI.this.undoMgr.getUndoName());
                jerooSourceArea.requestFocus();
                jerooSourceArea.setCaretPosition(n);
            }
        };
        this.copyControl = new JerooTextControl("Copy", JerooIcons.copyIcon, "Copy the selected text onto the clipboard", KeyStroke.getKeyStroke(67, 2), 67){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JerooSourceArea jerooSourceArea = (JerooSourceArea)this.getFocusedComponent();
                int n = jerooSourceArea.getCaretPosition();
                jerooSourceArea.copy();
                jerooSourceArea.requestFocus();
                jerooSourceArea.setCaretPosition(n);
            }
        };
        this.pasteControl = new JerooTextControl("Paste", JerooIcons.pasteIcon, "Insert a copy of the contents of the clipboard", KeyStroke.getKeyStroke(86, 2), 80){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JerooSourceArea jerooSourceArea = (JerooSourceArea)this.getFocusedComponent();
                jerooSourceArea.pasteText();
                JerooGUI.this.undoControl.putValue("ShortDescription", "Undo " + JerooGUI.this.undoMgr.getUndoName());
                jerooSourceArea.requestFocus();
            }
        };
        this.undoControl = new SourceUndoControl("Undo last edit", JerooIcons.undoIcon, "Undo", KeyStroke.getKeyStroke(90, 2), 78){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    JerooGUI.this.undoMgr.undoEditing();
                }
                catch (CannotUndoException cannotUndoException) {
                    JOptionPane.showMessageDialog(null, "Cannot undo: " + cannotUndoException);
                }
                this.updateUndoRedoStatus();
                JerooGUI.this.redoControl.updateUndoRedoStatus();
            }

            @Override
            public void updateUndoRedoStatus() {
                if (JerooGUI.this.undoMgr.canUndo()) {
                    this.setEnabled(true);
                    this.putValue("ShortDescription", "Undo " + JerooGUI.this.undoMgr.getUndoName());
                } else {
                    this.setEnabled(false);
                    this.putValue("ShortDescription", "Nothing to undo");
                }
            }

            @Override
            public void resume() {
                if (JerooGUI.this.undoMgr.canUndo()) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            }
        };
        this.redoControl = new SourceUndoControl("Redo last undo", JerooIcons.redoIcon, "Redo", KeyStroke.getKeyStroke(89, 2), 79){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    JerooGUI.this.undoMgr.redoEditing();
                }
                catch (CannotRedoException cannotRedoException) {
                    JOptionPane.showMessageDialog(null, "Cannot redo: " + cannotRedoException);
                }
                this.updateUndoRedoStatus();
                JerooGUI.this.undoControl.updateUndoRedoStatus();
            }

            @Override
            public void updateUndoRedoStatus() {
                if (JerooGUI.this.undoMgr.canRedo()) {
                    this.setEnabled(true);
                    this.putValue("ShortDescription", "Redo " + JerooGUI.this.undoMgr.getRedoName());
                } else {
                    this.setEnabled(false);
                    this.putValue("ShortDescription", "Nothing to redo");
                }
            }

            @Override
            public void resume() {
                if (JerooGUI.this.undoMgr.canRedo()) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            }
        };
        this.resetControl = new JerooControl("Reset", JerooIcons.resetIcon, "Reset the program and the island", KeyStroke.getKeyStroke(113, 0), 82){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JerooGUI.this.resumeSourceEditing();
                JerooGUI.this.resumeIslandEditing();
                JerooGUI.this.stepControl.setEnabled(true);
                JerooGUI.this.runControl.setEnabled(true);
                JerooGUI.this.speedControl.setEnabled(true);
                JerooGUI.this.pauseRunControl.setEnabled(false);
                JerooGUI.this.stopRunControl.setEnabled(false);
                JerooGUI.this.sourceTabPane.reset();
                JerooGUI.this.statusPanel.reset();
                JerooGUI.this.santongModel.reset();
                JerooGUI.this.resumeIslandEditing();
                JerooGUI.this.running = false;
            }
        };
        this.stepControl = new JerooControl("Run Stepwise", JerooIcons.runStepwiseIcon, "Run the program step-by-step", KeyStroke.getKeyStroke(114, 0), 83){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!JerooGUI.this.running) {
                    JerooGUI.this.flagMgr.setFlag(0, false);
                    JerooGUI.this.suspendSourceEditing();
                    JerooGUI.this.suspendIslandEditing();
                    JerooGUI.this.sourceTabPane.reset();
                    JerooGUI.this.resetControl.setEnabled(false);
                    JerooGUI.this.stopRunControl.setEnabled(true);
                    JerooGUI.this.santongModel.recordState();
                    JerooGUI.this.statusPanel.clearText();
                    try {
                        JerooGUI.this.updateObjectFile();
                        JerooGUI.this.jerooProcessor = new Processor(JerooGUI.this.objectFilePath, JerooGUI.this.santongModel);
                        JerooGUI.this.statusPanel.append("Stepping...\n");
                        JerooGUI.this.running = true;
                        JerooGUI.this.executionThread = new RunThread(JerooGUI.this.jerooProcessor, JerooGUI.this, 0L, false);
                        JerooGUI.this.executionThread.start();
                    }
                    catch (CompileException compileException) {
                        JerooGUI.this.flagMgr.setFlag(0, true);
                        SourceLineReference sourceLineReference = compileException.getSourceReference();
                        JerooGUI.this.statusPanel.append(compileException.getMessage());
                        JerooGUI.this.sourceTabPane.highlightLine(sourceLineReference.getPane(), sourceLineReference.getLine());
                        JerooGUI.this.resumeSourceEditing();
                        JerooGUI.this.resumeIslandEditing();
                        JerooGUI.this.resetControl.setEnabled(true);
                        JerooGUI.this.stopRunControl.setEnabled(false);
                        JerooGUI.this.running = false;
                    }
                    catch (IOException iOException) {
                        JerooGUI.this.statusPanel.append("I/O PROBLEM:  " + iOException.getMessage() + "\nContact your instructor.");
                        JerooGUI.this.resumeSourceEditing();
                        JerooGUI.this.resumeIslandEditing();
                        JerooGUI.this.resetControl.setEnabled(true);
                        JerooGUI.this.stopRunControl.setEnabled(false);
                        JerooGUI.this.running = false;
                    }
                    catch (Exception exception) {
                        JerooGUI.this.statusPanel.append("RUNTIME PROBLEM:  " + exception.getMessage() + "\nContact your instructor.");
                        JerooGUI.this.resumeSourceEditing();
                        JerooGUI.this.resumeIslandEditing();
                        JerooGUI.this.resetControl.setEnabled(true);
                        JerooGUI.this.stopRunControl.setEnabled(false);
                        JerooGUI.this.running = false;
                    }
                } else if (JerooGUI.this.executionThread.isAlive()) {
                    if (JerooGUI.this.paused) {
                        JerooGUI.this.paused = false;
                        JerooGUI.this.statusPanel.append("Stepping...\n");
                    }
                    JerooGUI.this.executionThread.performStep();
                }
            }
        };
        this.runControl = new JerooControl("Run Continuously", JerooIcons.runContinuouslyIcon, "Run the program continuously", KeyStroke.getKeyStroke(115, 0), 67){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = JerooGUI.this.speedControl.getValue() - 1;
                long l = JerooConstants.SLEEP_ARY[n];
                JerooGUI.this.pauseRunControl.setEnabled(true);
                JerooGUI.this.stopRunControl.setEnabled(true);
                if (!JerooGUI.this.running) {
                    JerooGUI.this.flagMgr.setFlag(0, false);
                    JerooGUI.this.suspendSourceEditing();
                    JerooGUI.this.suspendIslandEditing();
                    JerooGUI.this.sourceTabPane.reset();
                    JerooGUI.this.resetControl.setEnabled(false);
                    JerooGUI.this.stepControl.setEnabled(false);
                    this.setEnabled(false);
                    JerooGUI.this.speedControl.setEnabled(false);
                    JerooGUI.this.santongModel.recordState();
                    JerooGUI.this.statusPanel.clearText();
                    try {
                        JerooGUI.this.updateObjectFile();
                        JerooGUI.this.jerooProcessor = new Processor(JerooGUI.this.objectFilePath, JerooGUI.this.santongModel);
                        JerooGUI.this.statusPanel.append("Running...\n");
                        JerooGUI.this.running = true;
                        JerooGUI.this.executionThread = new RunThread(JerooGUI.this.jerooProcessor, JerooGUI.this, l, true);
                        JerooGUI.this.executionThread.start();
                    }
                    catch (CompileException compileException) {
                        JerooGUI.this.flagMgr.setFlag(0, true);
                        SourceLineReference sourceLineReference = compileException.getSourceReference();
                        JerooGUI.this.statusPanel.append(compileException.getMessage());
                        JerooGUI.this.sourceTabPane.highlightLine(sourceLineReference.getPane(), sourceLineReference.getLine());
                        JerooGUI.this.resumeSourceEditing();
                        JerooGUI.this.resumeIslandEditing();
                        JerooGUI.this.resetControl.setEnabled(true);
                        JerooGUI.this.stepControl.setEnabled(true);
                        JerooGUI.this.runControl.setEnabled(true);
                        JerooGUI.this.pauseRunControl.setEnabled(false);
                        JerooGUI.this.stopRunControl.setEnabled(false);
                        JerooGUI.this.running = false;
                    }
                    catch (IOException iOException) {
                        JerooGUI.this.statusPanel.append("I/O PROBLEM:  " + iOException.getMessage() + "\nContact your instructor.");
                        JerooGUI.this.resumeSourceEditing();
                        JerooGUI.this.resumeIslandEditing();
                        JerooGUI.this.resetControl.setEnabled(true);
                        JerooGUI.this.stepControl.setEnabled(true);
                        JerooGUI.this.runControl.setEnabled(true);
                        JerooGUI.this.pauseRunControl.setEnabled(false);
                        JerooGUI.this.stopRunControl.setEnabled(false);
                        JerooGUI.this.running = false;
                    }
                    catch (Exception exception) {
                        JerooGUI.this.statusPanel.append("RUNTIME PROBLEM:  " + exception.getMessage() + "\nContact your instructor.");
                        JerooGUI.this.resumeSourceEditing();
                        JerooGUI.this.resumeIslandEditing();
                        JerooGUI.this.resetControl.setEnabled(true);
                        JerooGUI.this.stepControl.setEnabled(true);
                        JerooGUI.this.runControl.setEnabled(true);
                        JerooGUI.this.pauseRunControl.setEnabled(false);
                        JerooGUI.this.stopRunControl.setEnabled(false);
                        JerooGUI.this.running = false;
                    }
                } else if (JerooGUI.this.executionThread.isAlive()) {
                    JerooGUI.this.paused = false;
                    JerooGUI.this.statusPanel.append("Running resumed...\n");
                    JerooGUI.this.executionThread.setDelayTime(l);
                    JerooGUI.this.executionThread.resumeRun();
                }
            }
        };
        this.pauseRunControl = new JerooControl("Pause", JerooIcons.pauseRunIcon, "Pause a continuously running program", KeyStroke.getKeyStroke(116, 0), 80){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (JerooGUI.this.executionThread != null && JerooGUI.this.executionThread.isAlive()) {
                    JerooGUI.this.executionThread.pauseRun();
                    JerooGUI.this.paused = true;
                    JerooGUI.this.statusPanel.append("Program paused by user\n");
                }
                JerooGUI.this.stepControl.setEnabled(true);
                JerooGUI.this.runControl.setEnabled(true);
                JerooGUI.this.speedControl.setEnabled(true);
                JerooGUI.this.pauseRunControl.setEnabled(false);
            }
        };
        this.stopRunControl = new JerooControl("Stop Run", JerooIcons.stopRunIcon, "Stop a running program", KeyStroke.getKeyStroke(117, 0), 84){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JerooGUI.this.executionThread.stopRun();
                JerooGUI.this.executionThread = null;
                JerooGUI.this.stepControl.setEnabled(false);
                JerooGUI.this.runControl.setEnabled(false);
                JerooGUI.this.pauseRunControl.setEnabled(false);
                this.setEnabled(false);
                JerooGUI.this.resetControl.setEnabled(true);
            }
        };
        this.speedControl = new JerooSpeedControl();
        this.newEnvControl = new JerooControl("New ...", JerooIcons.newEnvIcon, "Create a new island layout", KeyStroke.getKeyStroke(78, 3), 78){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = "Do you want to save your changes to the island?";
                String string2 = "Unsaved Changes To The Island";
                String string3 = "Save Changes";
                String string4 = "Discard Changes";
                String string5 = "Cancel \"new\" Operation";
                boolean bl = false;
                boolean bl2 = false;
                if (JerooGUI.this.santongModel.hasUnsavedChanges()) {
                    TwoButtonCancelDialog twoButtonCancelDialog = new TwoButtonCancelDialog(null, string, string2, string3, string4, string5);
                    JerooGUI.this.santongModel.setEditable(false);
                    twoButtonCancelDialog.setVisible(true);
                    String string6 = twoButtonCancelDialog.getValue();
                    twoButtonCancelDialog.dispose();
                    JerooGUI.this.santongModel.setEditable(true);
                    if (string6 != null) {
                        bl = string6.equals(string3);
                        bl2 = string6.equals(string5);
                    } else {
                        bl2 = true;
                    }
                }
                if (bl) {
                    JerooGUI.this.saveEnvControl.getButton().doClick();
                }
                if (!bl2) {
                    JerooGUI.this.currentEnvFile = null;
                    JerooGUI.this.updatePaths();
                    JerooGUI.this.updateTitle();
                    JerooGUI.this.santongModel.clear();
                    JerooGUI.this.santongModel.clearUnsavedChanges();
                }
            }
        };
        this.openEnvControl = new JerooControl("Open ...", JerooIcons.openEnvIcon, "Open an island file", KeyStroke.getKeyStroke(79, 3), 79){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                String string = "Do you want to save your changes to the island?";
                String string2 = "Unsaved Changes To The Island";
                String string3 = "Save Changes";
                String string4 = "Discard Changes";
                String string5 = "Cancel \"open\" Operation";
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = JerooGUI.this.santongModel.isEditable();
                if (bl3) {
                    JerooGUI.this.santongModel.setEditable(false);
                }
                if (JerooGUI.this.santongModel.hasUnsavedChanges()) {
                    TwoButtonCancelDialog twoButtonCancelDialog = new TwoButtonCancelDialog(null, string, string2, string3, string4, string5);
                    twoButtonCancelDialog.setVisible(true);
                    String string6 = twoButtonCancelDialog.getValue();
                    twoButtonCancelDialog.setVisible(false);
                    twoButtonCancelDialog.dispose();
                    if (string6 != null) {
                        bl = string6.equals(string3);
                        bl2 = string6.equals(string5);
                    } else {
                        bl2 = true;
                    }
                }
                if (bl) {
                    JerooGUI.this.saveEnvControl.getButton().doClick();
                }
                if (!bl2) {
                    boolean bl4;
                    if (JerooGUI.this.fileToOpen != null) {
                        JerooGUI.this.currentEnvFile = JerooGUI.this.fileToOpen;
                        bl4 = true;
                        JerooGUI.this.fileToOpen = null;
                    } else {
                        jFileChooser.addChoosableFileFilter(new JerooFileFilter("jev", "Jeroo Island Files (*.jev)"));
                        jFileChooser.setDialogTitle("Open a Jeroo island file");
                        jFileChooser.setCurrentDirectory(new File(JerooGUI.this.userPrefs.getPref("LastIslandDirectory")));
                        JerooGUI.this.santongModel.setEditable(false);
                        int n = jFileChooser.showOpenDialog(null);
                        JerooGUI.this.santongModel.setEditable(true);
                        if (n == 0) {
                            JerooGUI.this.currentEnvFile = jFileChooser.getSelectedFile();
                            bl4 = true;
                        } else {
                            bl4 = false;
                        }
                    }
                    if (bl4) {
                        try {
                            JerooGUI.this.santongModel.openFile(JerooGUI.this.currentEnvFile);
                            JerooGUI.this.recentFileMgr.addIslandFile(JerooGUI.this.currentEnvFile.getAbsolutePath());
                            JerooGUI.this.userPrefs.setPref("LastIslandDirectory", JerooGUI.this.currentEnvFile.getParent());
                            JerooGUI.this.updatePaths();
                            JerooGUI.this.updateTitle();
                        }
                        catch (IOException iOException) {
                            JOptionPane.showMessageDialog(null, "Unable to open or read the file");
                        }
                    }
                }
                if (bl3) {
                    JerooGUI.this.santongModel.setEditable(true);
                }
            }
        };
        this.saveEnvControl = new JerooControl("Save", JerooIcons.saveEnvIcon, "Save the island layout to a file", KeyStroke.getKeyStroke(83, 3), 83){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (JerooGUI.this.currentEnvFile == null) {
                    JerooGUI.this.saveAsEnvControl.getButton().doClick();
                } else {
                    try {
                        JerooGUI.this.santongModel.saveToFile(JerooGUI.this.currentEnvFile);
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(null, "Unable to save the island file");
                    }
                }
            }
        };
        this.saveAsEnvControl = new JerooControl("Save As ...", JerooIcons.saveAsEnvIcon, "Save the island layout to a different file", KeyStroke.getKeyStroke(65, 3), 65){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                boolean bl = JerooGUI.this.santongModel.isEditable();
                if (bl) {
                    JerooGUI.this.santongModel.setEditable(false);
                }
                jFileChooser.addChoosableFileFilter(new JerooFileFilter("jev", "Jeroo Island Files (*.jev)"));
                jFileChooser.setDialogTitle("Save a Jeroo island layout");
                jFileChooser.setCurrentDirectory(new File(JerooGUI.this.userPrefs.getPref("LastIslandDirectory")));
                int n = jFileChooser.showSaveDialog(null);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    if (!file.getName().endsWith(".jev")) {
                        file = new File(file.getPath() + ".jev");
                    }
                    if (file.exists()) {
                        String string = "File: \"" + file + "\" already exists!";
                        String string2 = "File Replacement Question";
                        String string3 = "Don't Save";
                        String string4 = "Replace It";
                        TwoButtonDialog twoButtonDialog = new TwoButtonDialog(null, string, string2, string3, string4);
                        twoButtonDialog.setVisible(true);
                        boolean bl2 = twoButtonDialog.getValue().equals(string3);
                        twoButtonDialog.dispose();
                        if (bl2) {
                            return;
                        }
                    }
                    JerooGUI.this.currentEnvFile = file;
                    try {
                        JerooGUI.this.santongModel.saveToFile(JerooGUI.this.currentEnvFile);
                        JerooGUI.this.recentFileMgr.addIslandFile(JerooGUI.this.currentEnvFile.getAbsolutePath());
                        JerooGUI.this.userPrefs.setPref("LastIslandDirectory", JerooGUI.this.currentEnvFile.getParent());
                        JerooGUI.this.updatePaths();
                        JerooGUI.this.updateTitle();
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(null, "Unable to save the island file");
                    }
                }
                if (bl) {
                    JerooGUI.this.santongModel.setEditable(true);
                }
            }
        };
        this.printEnvControl = new JerooControl("Print", JerooIcons.printEnvIcon, "Print the island layout", KeyStroke.getKeyStroke(80, 3), 80){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JerooGUI.this.santongModel.setEditable(false);
                JerooGUI.this.santongView.print(JerooGUI.this.envFilePath, JerooGUI.this.printID);
                JerooGUI.this.santongModel.setEditable(true);
            }
        };
        this.addFlowerControl = new JerooControl("Plant Flowers", JerooIcons.addFlowerIcon, "Plant flowers on the island", KeyStroke.getKeyStroke(118, 1), 80){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JerooGUI.this.santongView.setCursor(JerooGUI.this.flowerCursor);
                JerooGUI.this.santongModel.addFlowers();
            }
        };
        this.addNetControl = new JerooControl("Set Nets", JerooIcons.addNetIcon, "Set nets on the island", KeyStroke.getKeyStroke(119, 1), 78){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JerooGUI.this.santongView.setCursor(JerooGUI.this.netCursor);
                JerooGUI.this.santongModel.addNets();
            }
        };
        this.addWaterControl = new JerooControl("Add Water", JerooIcons.addWaterIcon, "Add water to the island", KeyStroke.getKeyStroke(120, 1), 87){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JerooGUI.this.santongView.setCursor(JerooGUI.this.waterCursor);
                JerooGUI.this.santongModel.addWater();
            }
        };
        this.clearEnvControl = new JerooControl("Clear Island", JerooIcons.clearEnvIcon, "Clear the island layout", KeyStroke.getKeyStroke(121, 1), 67){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JerooGUI.this.santongModel.clear();
            }
        };
        this.helpControl = new JerooControl("Language Summary", JerooIcons.helpIcon, "Open the Jeroo language summary", KeyStroke.getKeyStroke(112, 0), 72){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = JerooGUI.this.styleMgr.getCurrentStyleCode();
                if (n == 0) {
                    JerooGUI.this.javaHelpFrame.showHelp(JerooGUI.this.getLocationOnScreen());
                } else if (n == 1) {
                    JerooGUI.this.vbHelpFrame.showHelp(JerooGUI.this.getLocationOnScreen());
                } else {
                    JerooGUI.this.pythonHelpFrame.showHelp(JerooGUI.this.getLocationOnScreen());
                }
            }
        };
        this.exitControl = new JerooControl("Exit", JerooIcons.exitIcon, "Quit working with the Jeroo simulator", KeyStroke.getKeyStroke(81, 2), 88){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = true;
                if (JerooGUI.this.sourceTabPane.hasUnsavedChanges() || JerooGUI.this.santongModel.hasUnsavedChanges()) {
                    UnsavedFilesDialog unsavedFilesDialog = new UnsavedFilesDialog((Frame)JerooGUI.this, JerooGUI.this.sourceTabPane.hasUnsavedChanges(), JerooGUI.this.santongModel.hasUnsavedChanges(), JerooGUI.this.windowClosing);
                    unsavedFilesDialog.setVisible(true);
                    if (unsavedFilesDialog.exitCanceled()) {
                        bl = false;
                    } else if (unsavedFilesDialog.saveSelected()) {
                        if (unsavedFilesDialog.sourceSelected()) {
                            JerooGUI.this.saveSourceControl.getButton().doClick();
                        }
                        if (unsavedFilesDialog.islandSelected()) {
                            JerooGUI.this.saveEnvControl.getButton().doClick();
                        }
                    }
                    unsavedFilesDialog.setVisible(false);
                    unsavedFilesDialog.dispose();
                } else if (!JerooGUI.this.windowClosing) {
                    String string = "Please confirm your exit request.";
                    String string2 = "Jeroo Exit Confirmation";
                    String string3 = "Oops! Do not exit";
                    String string4 = "Yes!  I want to exit";
                    TwoButtonDialog twoButtonDialog = new TwoButtonDialog(JerooGUI.this, string, string2, string3, string4);
                    twoButtonDialog.setVisible(true);
                    boolean bl2 = twoButtonDialog.getValue().equals(string3);
                    bl = !bl2;
                    twoButtonDialog.setVisible(false);
                    twoButtonDialog.dispose();
                }
                if (JerooGUI.this.windowClosing || bl) {
                    JerooGUI.this.javaHelpFrame.dispose();
                    JerooGUI.this.javaHelpFrame = null;
                    JerooGUI.this.vbHelpFrame.dispose();
                    JerooGUI.this.vbHelpFrame = null;
                    JerooGUI.this.pythonHelpFrame.dispose();
                    JerooGUI.this.pythonHelpFrame = null;
                    JerooGUI.this.setVisible(true);
                    JerooGUI.this.dispose();
                    System.exit(0);
                }
            }
        };
        this.indentControl = new JerooTextControl("Indent Lines", null, "Indent the highlighted lines", KeyStroke.getKeyStroke(9, 0), 0){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JerooSourceArea jerooSourceArea = (JerooSourceArea)this.getFocusedComponent();
                if (jerooSourceArea.getSelectedText() != null) {
                    jerooSourceArea.indentLines();
                }
            }
        };
        this.unindentControl = new JerooTextControl("Unindent Lines", null, "Unindent the highlighted lines", KeyStroke.getKeyStroke(9, 64), 0){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JerooSourceArea jerooSourceArea = (JerooSourceArea)this.getFocusedComponent();
                if (jerooSourceArea.getSelectedText() != null) {
                    jerooSourceArea.unindentLines();
                }
            }
        };
        this.commentControl = new JerooTextControl("Comment Lines", null, "Comment the highlighted lines", JerooConstants.COMMENT_ACCELERATOR, 0){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JerooSourceArea jerooSourceArea = (JerooSourceArea)this.getFocusedComponent();
                jerooSourceArea.commentLines();
            }
        };
        this.uncommentControl = new JerooTextControl("Uncomment Lines", null, "Uncomment the highlighted lines", JerooConstants.UNCOMMENT_ACCELERATOR, 0){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JerooSourceArea jerooSourceArea = (JerooSourceArea)this.getFocusedComponent();
                jerooSourceArea.uncommentLines();
            }
        };
        this.preferencesControl = new JerooControl("Set Preferences", null, "View or modify preferences", null, 0){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserPreferences userPreferences = UserPreferences.getInstance();
                PreferencesModifyDialog preferencesModifyDialog = new PreferencesModifyDialog(userPreferences);
                boolean bl = JerooGUI.this.santongModel.isEditable();
                if (bl) {
                    JerooGUI.this.santongModel.setEditable(false);
                }
                preferencesModifyDialog.setVisible(true);
                if (preferencesModifyDialog.choiceIsSave()) {
                    String string = JerooGUI.this.printID.split(" -- ")[0];
                    userPreferences.saveToFile(PreferenceFile.getPrefFile());
                }
                preferencesModifyDialog.dispose();
                if (bl) {
                    JerooGUI.this.santongModel.setEditable(true);
                }
            }
        };
        this.fontControl = new JerooControl("Select Font", null, "Change font for the source code", null, 0){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserPreferences userPreferences = UserPreferences.getInstance();
                FontSelector fontSelector = new FontSelector(JerooGUI.this.sourceFont);
                boolean bl = JerooGUI.this.santongModel.isEditable();
                if (bl) {
                    JerooGUI.this.santongModel.setEditable(false);
                }
                fontSelector.setVisible(true);
                if (fontSelector.fontChanged()) {
                    JerooGUI.this.sourceFont = fontSelector.getSelectedFont();
                    JerooGUI.this.sourceTabPane.setSourceFont(JerooGUI.this.sourceFont);
                    if (fontSelector.saveRequested()) {
                        userPreferences.setFont(JerooGUI.this.sourceFont);
                        userPreferences.saveToFile(PreferenceFile.getPrefFile());
                    }
                }
                fontSelector.dispose();
                if (bl) {
                    JerooGUI.this.santongModel.setEditable(true);
                }
            }
        };
    }

    private void createCursors() {
        Toolkit toolkit = this.santongView.getToolkit();
        URL uRL = this.getClass().getClassLoader().getResource("Images/JerooLogo50.gif");
        String string = uRL.toString();
        string = string.substring(0, string.indexOf("JerooLogo50.gif"));
        try {
            this.noEnvEditCursor = toolkit.createCustomCursor(toolkit.getImage(new URL(string + "NoEditCursor.gif")), new Point(0, 0), null);
            this.flowerCursor = toolkit.createCustomCursor(toolkit.getImage(new URL(string + "FlowerCursor.gif")), new Point(0, 0), null);
            this.netCursor = toolkit.createCustomCursor(toolkit.getImage(new URL(string + "NetCursor.gif")), new Point(0, 0), null);
            this.waterCursor = toolkit.createCustomCursor(toolkit.getImage(new URL(string + "WaterCursor.gif")), new Point(0, 0), null);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void setCurrentSourceFile(File file) {
        this.currentSourceFile = file;
        this.currentObjectFile = null;
        this.updatePaths();
    }

    public void updatePaths() {
        this.sourceFilePath = this.currentSourceFile != null ? this.currentSourceFile.getAbsolutePath() : "none";
        if (this.currentSourceFile != null) {
            int n = this.sourceFilePath.lastIndexOf(".");
            this.objectFilePath = this.sourceFilePath.substring(0, n) + ".obj";
        } else {
            this.objectFilePath = null;
        }
        this.envFilePath = this.currentEnvFile != null ? this.currentEnvFile.getAbsolutePath() : "none";
    }

    public void updateTitle() {
        this.updatePaths();
        this.setTitle("Jeroo's World -- Source File: " + this.sourceFilePath + "     Island File: " + this.envFilePath);
    }

    public void updateObjectFile() throws CompileException, IOException {
        if (this.currentSourceFile == null) {
            if (this.saveAsSourceControl.isEnabled()) {
                this.saveAsSourceControl.getButton().doClick();
            } else {
                this.saveAsSourceControl.setEnabled(true);
                this.saveSourceControl.setEnabled(true);
                this.saveAsSourceControl.getButton().doClick();
                this.saveSourceControl.setEnabled(false);
                this.saveAsSourceControl.setEnabled(false);
            }
        }
        this.statusPanel.append("Saving Source Code...\n");
        if (this.saveSourceControl.isEnabled()) {
            this.saveSourceControl.getButton().doClick();
        } else {
            this.saveSourceControl.setEnabled(true);
            this.saveSourceControl.getButton().doClick();
            this.saveSourceControl.setEnabled(false);
        }
        if (this.currentObjectFile == null || !this.objectFilePath.equals(this.currentObjectFile.getPath())) {
            this.currentObjectFile = new File(this.objectFilePath);
        }
        this.jerooCompiler = this.styleMgr.getCurrentStyle().getCompiler();
        this.statusPanel.append("Compiling...\n");
        this.jerooCompiler.compile(this.sourceFilePath, this.objectFilePath);
    }

    public JerooStatusPanel getStatusPanel() {
        return this.statusPanel;
    }

    public void finishRunNormally() {
        String string = "Program Completed\n";
        this.handleRunTermination(string);
    }

    public void finishRunByUser() {
        String string = "Program stopped by User\n";
        this.handleRunTermination(string);
    }

    public void finishRunByException(String string) {
        String string2 = string + "\n";
        this.flagMgr.setFlag(0, true);
        this.handleRunTermination(string2);
    }

    private void handleRunTermination(String string) {
        this.running = false;
        this.paused = false;
        this.executionThread = null;
        this.jerooProcessor = null;
        this.statusPanel.setText("\n" + string);
        this.resumeSourceEditing();
        this.resetControl.setEnabled(true);
        this.stopRunControl.setEnabled(false);
        this.stepControl.setEnabled(false);
        this.runControl.setEnabled(false);
        this.pauseRunControl.setEnabled(false);
        this.stopRunControl.setEnabled(false);
    }

    public void updateNextSource(SourceLineReference sourceLineReference) {
        this.sourceTabPane.highlightLine(sourceLineReference.getPane(), sourceLineReference.getLine());
    }

    private void suspendIslandEditing() {
        this.newEnvControl.setEnabled(false);
        this.openEnvControl.setEnabled(false);
        this.saveEnvControl.setEnabled(false);
        this.saveAsEnvControl.setEnabled(false);
        for (int i = 0; i < this.recentIslandFiles.length; ++i) {
            this.recentIslandFiles[i].setEnabled(false);
        }
        this.addFlowerControl.setEnabled(false);
        this.addNetControl.setEnabled(false);
        this.addWaterControl.setEnabled(false);
        this.clearEnvControl.setEnabled(false);
        this.santongModel.setEditable(false);
        this.savedCursor = this.santongView.getCursor();
        this.santongView.setCursor(this.noEnvEditCursor);
    }

    private void resumeIslandEditing() {
        this.newEnvControl.setEnabled(true);
        this.openEnvControl.setEnabled(true);
        this.saveEnvControl.setEnabled(true);
        this.saveAsEnvControl.setEnabled(true);
        for (int i = 0; i < this.recentIslandFiles.length; ++i) {
            this.recentIslandFiles[i].setEnabled(true);
        }
        this.addFlowerControl.setEnabled(true);
        this.addNetControl.setEnabled(true);
        this.addWaterControl.setEnabled(true);
        this.clearEnvControl.setEnabled(true);
        this.santongModel.setEditable(true);
        this.santongView.setCursor(this.savedCursor);
    }

    private void suspendSourceEditing() {
        this.newSourceControl.setEnabled(false);
        this.openSourceControl.setEnabled(false);
        this.saveSourceControl.setEnabled(false);
        this.saveAsSourceControl.setEnabled(false);
        for (int i = 0; i < this.recentSourceFiles.length; ++i) {
            this.recentSourceFiles[i].setEnabled(false);
        }
        this.cutControl.setEnabled(false);
        this.copyControl.setEnabled(false);
        this.pasteControl.setEnabled(false);
        this.undoControl.suspend();
        this.redoControl.suspend();
        this.sourceTabPane.setEditable(false);
    }

    private void resumeSourceEditing() {
        this.newSourceControl.setEnabled(true);
        this.openSourceControl.setEnabled(true);
        this.saveSourceControl.setEnabled(true);
        this.saveAsSourceControl.setEnabled(true);
        for (int i = 0; i < this.recentSourceFiles.length; ++i) {
            this.recentSourceFiles[i].setEnabled(true);
        }
        this.cutControl.setEnabled(true);
        this.copyControl.setEnabled(true);
        this.pasteControl.setEnabled(true);
        this.undoControl.updateUndoRedoStatus();
        this.redoControl.updateUndoRedoStatus();
        this.sourceTabPane.setEditable(true);
    }

    public void setPrintID(String string) {
        this.printID = string;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Jeroo Home")) {
            this.santongModel.setEditable(false);
            this.reporter.showHome();
            this.santongModel.setEditable(true);
        } else if (actionEvent.getActionCommand().equals("Jeroo Tutorial")) {
            TutorialFrame tutorialFrame;
            int n = this.styleMgr.getCurrentStyleCode();
            this.newEnvControl.getButton().doClick();
            this.newSourceControl.getButton().doClick();
            this.styleMgr.setCurrentStyle(n);
            if (n == 0) {
                tutorialFrame = new JavaTutorialFrame(this.mainSourceArea);
                tutorialFrame.showTutorial(this.getLocationOnScreen());
            } else if (n == 1) {
                tutorialFrame = new VBTutorialFrame(this.mainSourceArea);
                tutorialFrame.showTutorial(this.getLocationOnScreen());
            } else {
                tutorialFrame = new PythonTutorialFrame(this.mainSourceArea);
                tutorialFrame.showTutorial(this.getLocationOnScreen());
            }
            tutorialFrame.setVisible(true);
        } else if (actionEvent.getActionCommand().equals("About Jeroo")) {
            this.santongModel.setEditable(false);
            this.reporter.aboutJeroo();
            this.santongModel.setEditable(true);
        } else if (actionEvent.getActionCommand().equals("Jeroo History")) {
            this.santongModel.setEditable(false);
            this.reporter.showHistory();
            this.santongModel.setEditable(true);
        } else if (actionEvent.getActionCommand().equals("Show Copyright")) {
            this.santongModel.setEditable(false);
            this.reporter.showCopyright();
            this.santongModel.setEditable(true);
        } else if (actionEvent.getActionCommand().equals("Show Awards")) {
            this.santongModel.setEditable(false);
            this.reporter.showAwards();
            this.santongModel.setEditable(true);
        } else if (actionEvent.getSource() instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getText();
            if (new Vector<JMenuItem>(Arrays.asList(this.recentSourceFiles)).contains(jMenuItem)) {
                this.fileToOpen = new File(string);
                if (this.fileToOpen.exists()) {
                    this.openSourceControl.getButton().doClick();
                } else {
                    this.recentFileMgr.removeSourceFile(string);
                    JOptionPane.showMessageDialog(null, "File: " + string + " no longer exists!");
                }
                this.fileToOpen = null;
            } else if (new Vector<JMenuItem>(Arrays.asList(this.recentIslandFiles)).contains(jMenuItem)) {
                this.fileToOpen = new File(string);
                if (this.fileToOpen.exists()) {
                    this.openEnvControl.getButton().doClick();
                } else {
                    this.recentFileMgr.removeIslandFile(string);
                    JOptionPane.showMessageDialog(null, "File: " + string + " no longer exists!");
                }
                this.fileToOpen = null;
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }
}

