/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.Keymap;

public class JerooSourceArea
extends JTextArea
implements PropertyChangeListener {
    private SourceUndoManager undoMgr;
    private Highlighter textHighlighter;
    private Color highlightColor;
    private UserPreferences prefs;
    private LanguageStyleManager styleMgr;
    private String softTabString;
    private int indentAmount = 0;
    private String indentStr = "";
    private StringBuffer blanks;
    private Keymap currentKeymap;
    private KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
    private KeyStroke tab = KeyStroke.getKeyStroke(9, 0);
    private KeyStroke backTab = KeyStroke.getKeyStroke(9, 64);
    private KeyStroke ctrl_X = KeyStroke.getKeyStroke(88, 128);
    private KeyStroke ctrl_V = KeyStroke.getKeyStroke(86, 128);
    private AbstractAction autoIndentAction;
    private AbstractAction softTabAction;
    private AbstractAction backTabAction;
    private AbstractAction ctrl_X_Action;
    private AbstractAction ctrl_V_Action;

    public JerooSourceArea(int n, int n2) {
        this("", n, n2);
    }

    public JerooSourceArea(String string, int n, int n2) {
        super(string, n, n2);
        this.blanks = new StringBuffer(60);
        for (int i = 0; i < 60; ++i) {
            this.blanks.insert(0, ' ');
        }
        this.prefs = UserPreferences.getInstance();
        this.prefs.addPropertyChangeListener(this);
        this.styleMgr = LanguageStyleManager.getInstance();
        this.undoMgr = SourceUndoManager.getInstance();
        this.setTabs(Integer.parseInt(this.prefs.getPref("TabSize")));
        this.textHighlighter = this.getHighlighter();
        this.highlightColor = new Color(198, 198, 250);
        this.defineKeystrokeActions();
        this.currentKeymap = this.getKeymap();
        this.currentKeymap.addActionForKeyStroke(this.tab, this.softTabAction);
        this.currentKeymap.addActionForKeyStroke(this.backTab, this.backTabAction);
        this.currentKeymap.addActionForKeyStroke(this.ctrl_X, this.ctrl_X_Action);
        this.currentKeymap.addActionForKeyStroke(this.ctrl_V, this.ctrl_V_Action);
        if (this.prefs.autoIndentIsSet()) {
            this.currentKeymap.addActionForKeyStroke(this.enter, this.autoIndentAction);
        }
    }

    public void setTabs(int n) {
        this.setTabSize(n);
        this.softTabString = JerooConstants.SOFT_TAB[n];
    }

    public void setHighlightColor(Color color) {
        this.highlightColor = color;
    }

    public void removeHighlights() {
        this.textHighlighter.removeAllHighlights();
    }

    public void highlightLine(int n) {
        try {
            DefaultHighlighter.DefaultHighlightPainter defaultHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(this.highlightColor);
            int n2 = this.getLineStartOffset(n - 1);
            int n3 = this.getLineEndOffset(n - 1);
            this.removeHighlights();
            this.textHighlighter.addHighlight(n2, n3, defaultHighlightPainter);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void highlightLine(int n, Color color) {
        try {
            DefaultHighlighter.DefaultHighlightPainter defaultHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(color);
            int n2 = this.getLineStartOffset(n - 1);
            int n3 = this.getLineEndOffset(n - 1);
            this.removeHighlights();
            this.textHighlighter.addHighlight(n2, n3, defaultHighlightPainter);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void setAutoIndent(boolean bl) {
        if (bl) {
            // empty if block
        }
    }

    public void indentLines() {
        SourceLineGroup sourceLineGroup = new SourceLineGroup();
        if (this.undoMgr != null) {
            this.undoMgr.startUndoGroup("INDENT LINES");
        }
        try {
            int n = this.getSelectionStart();
            int n2 = this.getLineOfOffset(n);
            n = this.getLineStartOffset(n2);
            int n3 = this.getSelectionEnd();
            int n4 = this.getLineOfOffset(n3);
            n3 = this.getLineEndOffset(n4);
            for (int i = n2; i <= n4; ++i) {
                int n5 = this.getLineStartOffset(i);
                int n6 = this.getLineEndOffset(i);
                sourceLineGroup.addLine(this.getText(n5, n6 - n5));
            }
            sourceLineGroup.indent(this.getTabSize());
            this.replaceRange(sourceLineGroup.toString(), n, n3);
            this.removeHighlights();
            if (n4 < this.getLineCount() - 1) {
                this.setCaretPosition(this.getLineEndOffset(n4) - 1);
            } else {
                this.setCaretPosition(this.getLineEndOffset(n4));
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (this.undoMgr != null) {
            this.undoMgr.endUndoGroup();
        }
    }

    public void commentLines() {
        SourceLineGroup sourceLineGroup = new SourceLineGroup();
        SourceUndoManager sourceUndoManager = SourceUndoManager.getInstance();
        if (sourceUndoManager != null) {
            sourceUndoManager.startUndoGroup("COMMENT LINES");
        }
        try {
            int n = this.getSelectionStart();
            int n2 = this.getLineOfOffset(n);
            n = this.getLineStartOffset(n2);
            int n3 = this.getSelectionEnd();
            int n4 = this.getLineOfOffset(n3);
            n3 = this.getLineEndOffset(n4);
            for (int i = n2; i <= n4; ++i) {
                int n5 = this.getLineStartOffset(i);
                int n6 = this.getLineEndOffset(i);
                sourceLineGroup.addLine(this.getText(n5, n6 - n5));
            }
            sourceLineGroup.insertPrefix(this.styleMgr.getCurrentStyle().getCommentPrefix());
            this.replaceRange(sourceLineGroup.toString(), n, n3);
            this.removeHighlights();
            if (n4 < this.getLineCount() - 1) {
                this.setCaretPosition(this.getLineEndOffset(n4) - 1);
            } else {
                this.setCaretPosition(this.getLineEndOffset(n4));
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (sourceUndoManager != null) {
            sourceUndoManager.endUndoGroup();
        }
    }

    public void uncommentLines() {
        SourceLineGroup sourceLineGroup = new SourceLineGroup();
        if (this.undoMgr != null) {
            this.undoMgr.startUndoGroup("UNCOMMENT LINES");
        }
        try {
            int n = this.getSelectionStart();
            int n2 = this.getLineOfOffset(n);
            n = this.getLineStartOffset(n2);
            int n3 = this.getSelectionEnd();
            int n4 = this.getLineOfOffset(n3);
            n3 = this.getLineEndOffset(n4);
            for (int i = n2; i <= n4; ++i) {
                int n5 = this.getLineStartOffset(i);
                int n6 = this.getLineEndOffset(i);
                sourceLineGroup.addLine(this.getText(n5, n6 - n5));
            }
            sourceLineGroup.removePrefix(this.styleMgr.getCurrentStyle().getCommentPrefix());
            this.replaceRange(sourceLineGroup.toString(), n, n3);
            this.removeHighlights();
            if (n4 < this.getLineCount() - 1) {
                this.setCaretPosition(this.getLineEndOffset(n4) - 1);
            } else {
                this.setCaretPosition(this.getLineEndOffset(n4));
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (this.undoMgr != null) {
            this.undoMgr.endUndoGroup();
        }
    }

    public void unindentLines() {
        SourceLineGroup sourceLineGroup = new SourceLineGroup();
        if (this.undoMgr != null) {
            this.undoMgr.startUndoGroup("UNINDENT LINES");
        }
        try {
            int n = this.getSelectionStart();
            int n2 = this.getLineOfOffset(n);
            n = this.getLineStartOffset(n2);
            int n3 = this.getSelectionEnd();
            int n4 = this.getLineOfOffset(n3);
            n3 = this.getLineEndOffset(n4);
            for (int i = n2; i <= n4; ++i) {
                int n5 = this.getLineStartOffset(i);
                int n6 = this.getLineEndOffset(i);
                sourceLineGroup.addLine(this.getText(n5, n6 - n5));
            }
            sourceLineGroup.unindent(this.getTabSize());
            this.replaceRange(sourceLineGroup.toString(), n, n3);
            this.removeHighlights();
            if (n4 < this.getLineCount() - 1) {
                this.setCaretPosition(this.getLineEndOffset(n4) - 1);
            } else {
                this.setCaretPosition(this.getLineEndOffset(n4));
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (this.undoMgr != null) {
            this.undoMgr.endUndoGroup();
        }
    }

    public void cutText() {
        if (this.undoMgr != null) {
            this.undoMgr.startUndoGroup("CUT");
        }
        super.cut();
        if (this.undoMgr != null) {
            this.undoMgr.endUndoGroup();
        }
    }

    public void pasteText() {
        if (this.undoMgr != null) {
            this.undoMgr.startUndoGroup("PASTE");
        }
        super.paste();
        if (this.undoMgr != null) {
            this.undoMgr.endUndoGroup();
        }
    }

    private void defineKeystrokeActions() {
        this.autoIndentAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JerooSourceArea jerooSourceArea = (JerooSourceArea)actionEvent.getSource();
                int n = jerooSourceArea.getCaretPosition();
                try {
                    int n2 = jerooSourceArea.getLineOfOffset(n);
                    int n3 = jerooSourceArea.getLineStartOffset(n2);
                    int n4 = jerooSourceArea.getLineEndOffset(n2);
                    String string = jerooSourceArea.getText(n3, n4 - n3);
                    String string2 = string.trim();
                    int n5 = string.indexOf(string2);
                    if (string2.length() > 0 && n5 != JerooSourceArea.this.indentAmount) {
                        JerooSourceArea.this.indentAmount = n5;
                        JerooSourceArea.this.indentStr = JerooSourceArea.this.blanks.substring(0, JerooSourceArea.this.indentAmount);
                    }
                    jerooSourceArea.insert("\n" + JerooSourceArea.this.indentStr, n);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        };
        this.softTabAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JerooSourceArea jerooSourceArea = (JerooSourceArea)actionEvent.getSource();
                if (jerooSourceArea.getSelectedText() != null) {
                    jerooSourceArea.indentLines();
                } else {
                    int n = jerooSourceArea.getCaretPosition();
                    jerooSourceArea.insert(JerooSourceArea.this.softTabString, n);
                }
            }
        };
        this.backTabAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JerooSourceArea jerooSourceArea = (JerooSourceArea)actionEvent.getSource();
                int n = jerooSourceArea.getCaretPosition();
                int n2 = jerooSourceArea.getTabSize();
                if (jerooSourceArea.getSelectedText() != null) {
                    jerooSourceArea.unindentLines();
                } else {
                    try {
                        int n3 = jerooSourceArea.getLineOfOffset(n);
                        int n4 = jerooSourceArea.getLineStartOffset(n3);
                        int n5 = Math.max(n4, n - n2);
                        jerooSourceArea.setCaretPosition(n5);
                    }
                    catch (BadLocationException badLocationException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        };
        this.ctrl_X_Action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JerooSourceArea jerooSourceArea = (JerooSourceArea)actionEvent.getSource();
                jerooSourceArea.cutText();
            }
        };
        this.ctrl_V_Action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JerooSourceArea jerooSourceArea = (JerooSourceArea)actionEvent.getSource();
                jerooSourceArea.pasteText();
            }
        };
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("Autoindent Property")) {
            String string2 = (String)propertyChangeEvent.getNewValue();
            if (string2.equals("true")) {
                this.currentKeymap.addActionForKeyStroke(this.enter, this.autoIndentAction);
            } else {
                this.currentKeymap.removeKeyStrokeBinding(this.enter);
            }
        } else if (string.equals("Tab Property")) {
            int n = Integer.parseInt((String)propertyChangeEvent.getNewValue());
            this.setTabs(n);
        }
    }
}

