/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JOptionPane;

public class JerooSourcePrinter
implements Printable {
    private static String PRINT_FONT_FAMILY = "Monospaced";
    private static int PRINT_FONT_SIZE = 10;
    private static int PRINT_FONT_STYLE = 0;
    private static float PRINT_LINESPACE_FACTOR = 1.1f;
    private static String errMsg = "Unable to print the source code";
    private String[] mainLines;
    private String[] methodLines;
    private StringBuffer[] headerLines = new StringBuffer[3];
    private PrinterJob sourcePrinter;
    private PageFormat sourcePageFormat;
    private Font printFont = new Font(PRINT_FONT_FAMILY, PRINT_FONT_STYLE, PRINT_FONT_SIZE);
    private int lineSpacing;
    private int sourceLinesPerPage;
    private int headerLineCount = 4;
    private int totalLinesPerPage;
    private int headerHeight;
    private int pagesForMain;
    private int pagesForMethods;
    private int totalPages;

    private int pages(String[] stringArray) {
        if (stringArray.length == 1 && stringArray[0].equals("")) {
            return 0;
        }
        if (stringArray.length % this.sourceLinesPerPage == 0) {
            return stringArray.length / this.sourceLinesPerPage;
        }
        return 1 + stringArray.length / this.sourceLinesPerPage;
    }

    private void setHeader(String string, String string2) {
        this.headerLines[0] = this.totalPages < 10 ? new StringBuffer("Page 00 of 0" + this.totalPages) : new StringBuffer("Page 00 of " + this.totalPages);
        this.headerLines[1] = new StringBuffer("     FILE: " + string);
        this.headerLines[2] = new StringBuffer("     " + string2);
    }

    private void print() {
        if (this.sourcePrinter.printDialog()) {
            try {
                this.sourcePrinter.setPrintable(this);
                this.sourcePrinter.print();
            }
            catch (PrinterException printerException) {
                JOptionPane.showMessageDialog(null, errMsg + ": " + printerException.getMessage(), "Printing Error", 0);
            }
        }
    }

    public void printAll(String string, String string2, String[] stringArray, String[] stringArray2) {
        this.mainLines = stringArray;
        this.methodLines = stringArray2;
        this.pagesForMain = this.pages(this.mainLines);
        this.pagesForMethods = this.pages(this.methodLines);
        this.totalPages = this.pagesForMain + this.pagesForMethods;
        if (this.totalPages == 0) {
            JOptionPane.showMessageDialog(null, "There is no source code to print", "Print request error", 0);
            return;
        }
        this.setHeader(string, string2);
        this.print();
    }

    public void printMain(String string, String string2, String[] stringArray) {
        this.mainLines = stringArray;
        this.pagesForMain = this.pages(this.mainLines);
        this.pagesForMethods = 0;
        this.totalPages = this.pagesForMain + this.pagesForMethods;
        if (this.totalPages == 0) {
            JOptionPane.showMessageDialog(null, "There is no main method to print", "Print request error", 0);
            return;
        }
        this.setHeader(string, string2);
        this.print();
    }

    public void printMethods(String string, String string2, String[] stringArray) {
        this.methodLines = stringArray;
        this.pagesForMain = 0;
        this.pagesForMethods = this.pages(this.methodLines);
        this.totalPages = this.pagesForMain + this.pagesForMethods;
        if (this.totalPages == 0) {
            JOptionPane.showMessageDialog(null, "There are no Jeroo methods to print", "Print request error", 0);
            return;
        }
        this.setHeader(string, string2);
        this.print();
    }

    public JerooSourcePrinter() {
        this.sourcePrinter = PrinterJob.getPrinterJob();
        this.sourcePageFormat = this.sourcePrinter.defaultPage();
        this.lineSpacing = (int)((float)PRINT_FONT_SIZE * PRINT_LINESPACE_FACTOR);
        this.totalLinesPerPage = (int)Math.floor(this.sourcePageFormat.getImageableHeight() / (double)this.lineSpacing);
        this.sourceLinesPerPage = this.totalLinesPerPage - this.headerLineCount;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n < 0 || n >= this.totalPages) {
            return 1;
        }
        int n2 = n + 1;
        if (n2 < 10) {
            this.headerLines[0].replace(6, 7, "" + n2);
        } else {
            this.headerLines[0].replace(5, 7, "" + n2);
        }
        int n3 = graphics.getFontMetrics(this.printFont).stringWidth(this.headerLines[0].toString());
        int n4 = (int)pageFormat.getImageableWidth() - n3;
        int n5 = graphics.getFontMetrics(this.printFont).getAscent();
        int n6 = (int)pageFormat.getImageableX();
        this.headerHeight = this.headerLineCount * this.lineSpacing;
        graphics.setColor(Color.WHITE);
        graphics.fillRect((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY(), (int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight());
        graphics.setColor(Color.LIGHT_GRAY);
        graphics.fillRoundRect((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY(), (int)pageFormat.getImageableWidth(), this.headerHeight, 10, 10);
        graphics.setFont(this.printFont);
        graphics.setColor(Color.BLACK);
        if (n < this.pagesForMain) {
            int n7 = n * this.sourceLinesPerPage;
            int n8 = Math.min(n7 + this.sourceLinesPerPage, this.mainLines.length);
            int n9 = (int)(pageFormat.getImageableY() + (double)n5);
            graphics.drawString("     MAIN METHOD", n6, n9);
            graphics.drawString(this.headerLines[0].toString(), n4, n9);
            graphics.drawString(this.headerLines[1].toString(), n6, n9 += this.lineSpacing);
            graphics.drawString(this.headerLines[2].toString(), n6, n9 += this.lineSpacing);
            n9 += 2 * this.lineSpacing;
            for (int i = n7; i < n8; ++i) {
                graphics.drawString(this.mainLines[i], n6, n9);
                n9 += this.lineSpacing;
            }
        } else {
            int n10 = (n - this.pagesForMain) * this.sourceLinesPerPage;
            int n11 = Math.min(n10 + this.sourceLinesPerPage, this.methodLines.length);
            int n12 = (int)(pageFormat.getImageableY() + (double)n5);
            graphics.drawString("     JEROO METHODS", n6, n12);
            graphics.drawString(this.headerLines[0].toString(), n4, n12);
            graphics.drawString(this.headerLines[1].toString(), n6, n12 += this.lineSpacing);
            graphics.drawString(this.headerLines[2].toString(), n6, n12 += this.lineSpacing);
            n12 += 2 * this.lineSpacing;
            for (int i = n10; i < n11; ++i) {
                graphics.drawString(this.methodLines[i], n6, n12);
                n12 += this.lineSpacing;
            }
        }
        return 0;
    }
}

