/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;

public class JerooSourceTabs
extends JTabbedPane
implements ChangeListener,
DocumentListener,
MouseListener,
PropertyChangeListener {
    private JScrollPane mainScrollPane = new JScrollPane();
    private JScrollPane methodScrollPane = new JScrollPane();
    private JerooSourceArea mainSourceArea;
    private JerooSourceArea methodSourceArea;
    private JerooSourceArea currentSourceArea;
    private Icon activeIcon = JerooIcons.activeSourceTabIcon;
    private JerooSourcePrinter sourcePrinter;
    private SourceUndoManager undoMgr = SourceUndoManager.getInstance();
    private JerooFlagManager flagMgr = JerooFlagManager.getInstance();
    private int currentPaneIndex;
    private LanguageStyleManager styleMgr = LanguageStyleManager.getInstance();

    public JerooSourceTabs(JerooSourceArea jerooSourceArea, JerooSourceArea jerooSourceArea2) {
        this.mainSourceArea = jerooSourceArea;
        this.mainScrollPane.getViewport().add(this.mainSourceArea);
        this.addTab("main method", this.mainScrollPane);
        this.methodSourceArea = jerooSourceArea2;
        this.methodScrollPane.getViewport().add(this.methodSourceArea);
        this.addTab("Jeroo methods", this.methodScrollPane);
        this.flagMgr.setFlag(1, false);
        this.mainSourceArea.getDocument().addDocumentListener(this);
        this.methodSourceArea.getDocument().addDocumentListener(this);
        this.setSourceFont(JerooConstants.DEFAULT_SOURCE_FONT);
        this.setMaximumSize(JerooConstants.SOURCE_TABS_DIMENSION);
        this.setPreferredSize(JerooConstants.SOURCE_TABS_DIMENSION);
        this.setSize(JerooConstants.SOURCE_TABS_DIMENSION);
        this.addMouseListener(this);
        this.addChangeListener(this);
        this.styleMgr.addPropertyChangeListener(this);
        this.currentSourceArea = this.mainSourceArea;
        this.setCurrentPane(0);
    }

    public void addSourceUndoListener(UndoableEditListener undoableEditListener) {
        this.mainSourceArea.getDocument().addUndoableEditListener(undoableEditListener);
        this.methodSourceArea.getDocument().addUndoableEditListener(undoableEditListener);
    }

    public void addSourceMouseListener(MouseListener mouseListener) {
        this.mainSourceArea.addMouseListener(mouseListener);
        this.methodSourceArea.addMouseListener(mouseListener);
    }

    public void setEditable(boolean bl) {
        this.mainSourceArea.setEditable(bl);
        this.methodSourceArea.setEditable(bl);
    }

    public void highlightLine(int n, int n2) {
        if (n != this.currentPaneIndex) {
            this.setCurrentPane(n);
            this.currentSourceArea = this.currentPaneIndex == 0 ? this.mainSourceArea : this.methodSourceArea;
        }
        JScrollPane jScrollPane = this.currentPaneIndex == 0 ? this.mainScrollPane : this.methodScrollPane;
        JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
        int n3 = (jScrollBar.getMaximum() - jScrollBar.getMinimum()) / this.currentSourceArea.getLineCount();
        int n4 = jScrollBar.getValue() / n3;
        if (n2 - n4 < 5) {
            while (n2 - (n4 -= 10) < 5) {
            }
            jScrollBar.setValue(Math.max(n4 * n3, jScrollBar.getMinimum()));
        } else if (n2 - n4 > 15) {
            while (n2 - (n4 += 10) > 15) {
            }
            jScrollBar.setValue(Math.min(n4 * n3, jScrollBar.getMaximum()));
        }
        this.currentSourceArea.highlightLine(n2);
    }

    public void setCurrentPane(int n) {
        this.currentPaneIndex = n;
        this.currentSourceArea = this.currentPaneIndex == 0 ? this.mainSourceArea : this.methodSourceArea;
        this.setSelectedIndex(n);
        this.setIconAt(n, this.activeIcon);
        this.setIconAt(1 - n, null);
    }

    public void reset() {
        this.mainSourceArea.removeHighlights();
        this.methodSourceArea.removeHighlights();
        this.setCurrentPane(0);
    }

    public void printAll(String string, String string2) {
        this.sourcePrinter = new JerooSourcePrinter();
        this.sourcePrinter.printAll(string, string2, this.mainSourceArea.getText().split("\n"), this.methodSourceArea.getText().split("\n"));
    }

    public void printMain(String string, String string2) {
        this.sourcePrinter = new JerooSourcePrinter();
        this.sourcePrinter.printMain(string, string2, this.mainSourceArea.getText().split("\n"));
    }

    public void printMethods(String string, String string2) {
        this.sourcePrinter = new JerooSourcePrinter();
        this.sourcePrinter.printMethods(string, string2, this.methodSourceArea.getText().split("\n"));
    }

    public boolean hasUnsavedChanges() {
        return this.flagMgr.isSet(1);
    }

    public void clearUnsavedChanges() {
        this.flagMgr.setFlag(1, false);
    }

    public void openFile(File file) throws IOException {
        int n;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String[] stringArray = this.styleMgr.getSourcePrefixes();
        String string = bufferedReader.readLine();
        for (n = 0; n < stringArray.length && !string.startsWith(stringArray[n]); ++n) {
        }
        if (n >= stringArray.length) {
            this.styleMgr.setCurrentStyle(0);
        } else {
            this.styleMgr.setCurrentStyle(n);
            string = bufferedReader.readLine();
        }
        this.methodSourceArea.setText("");
        while (!string.startsWith("@@")) {
            this.methodSourceArea.append(string + "\n");
            string = bufferedReader.readLine();
        }
        string = bufferedReader.readLine();
        this.mainSourceArea.setText("");
        while (string != null) {
            this.mainSourceArea.append(string + "\n");
            string = bufferedReader.readLine();
        }
        bufferedReader.close();
        this.clearUnsavedChanges();
        this.mainSourceArea.setCaretPosition(0);
    }

    public void saveToFile(File file) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.write(this.styleMgr.getCurrentStyle().getSourcePrefix() + "\n");
        String string = this.methodSourceArea.getText();
        if (string.endsWith("\n")) {
            bufferedWriter.write(string + "@@\n");
        } else {
            bufferedWriter.write(string + "\n@@\n");
        }
        bufferedWriter.write(this.mainSourceArea.getText());
        bufferedWriter.flush();
        bufferedWriter.close();
        this.clearUnsavedChanges();
    }

    public void setSourceFont(Font font) {
        this.mainSourceArea.setFont(font);
        this.methodSourceArea.setFont(font);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.flagMgr.setFlag(1, true);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.flagMgr.setFlag(1, true);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.flagMgr.setFlag(1, true);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.getSelectedIndex();
        JerooSourceArea jerooSourceArea = (JerooSourceArea)((JScrollPane)this.getComponentAt(n)).getViewport().getView();
        jerooSourceArea.requestFocusInWindow();
        this.undoMgr.markMouseClick();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.currentPaneIndex = this.getSelectedIndex();
        this.setIconAt(this.currentPaneIndex, this.activeIcon);
        this.setIconAt(1 - this.currentPaneIndex, null);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("Current Style Property")) {
            int n = (Integer)propertyChangeEvent.getNewValue();
            this.setTitleAt(0, JerooConstants.MAIN_TAB_TITLE[n]);
            this.setTitleAt(1, JerooConstants.METHOD_TAB_TITLE[n]);
        }
    }
}

