/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JerooSpeedControl
implements ActionListener,
ChangeListener {
    private final int MIN_VAL = 1;
    private final int MAX_VAL = 6;
    private final int INITIAL_VAL = 3;
    private final String TOOL_TIP = "1--Slow  3--Medium  5--Fast  6--Max";
    private JMenu menu = new JMenu("Run Speed");
    private JRadioButtonMenuItem[] itemAry = new JRadioButtonMenuItem[]{new JRadioButtonMenuItem("1--Slow"), new JRadioButtonMenuItem("2"), new JRadioButtonMenuItem("3--Medium"), new JRadioButtonMenuItem("4"), new JRadioButtonMenuItem("5--Fast"), new JRadioButtonMenuItem("6--Max")};
    private ButtonGroup buttonGroup = new ButtonGroup();
    private JSlider slider;

    public JerooSpeedControl() {
        for (int i = 0; i < this.itemAry.length; ++i) {
            this.buttonGroup.add(this.itemAry[i]);
            this.menu.add(this.itemAry[i]);
            this.itemAry[i].setActionCommand(String.valueOf(i + 1));
            this.itemAry[i].addActionListener(this);
        }
        this.itemAry[2].setSelected(true);
        this.slider = new JSlider(0, 1, 6, 3);
        this.slider.setMajorTickSpacing(1);
        this.slider.setPaintLabels(true);
        this.slider.setSnapToTicks(true);
        this.slider.setToolTipText("1--Slow  3--Medium  5--Fast  6--Max");
        this.slider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.slider.setSize(JerooConstants.SPEED_CONTROL_DIMENSION);
        this.slider.setMaximumSize(JerooConstants.SPEED_CONTROL_DIMENSION);
        this.slider.setPreferredSize(JerooConstants.SPEED_CONTROL_DIMENSION);
        this.slider.addChangeListener(this);
    }

    public void setEnabled(boolean bl) {
        this.menu.setEnabled(bl);
        this.slider.setEnabled(bl);
    }

    public JSlider getSlider() {
        return this.slider;
    }

    public JMenu getMenu() {
        return this.menu;
    }

    public int getValue() {
        return this.slider.getValue();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = ((JRadioButtonMenuItem)actionEvent.getSource()).getActionCommand();
        int n = Integer.parseInt(string);
        this.slider.setValue(n);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (!this.slider.getValueIsAdjusting()) {
            this.itemAry[this.slider.getValue() - 1].setSelected(true);
        }
    }
}

