/*
 * Decompiled with CFR 0.152.
 */
import java.awt.FlowLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JerooStatusView
extends JPanel
implements PropertyChangeListener {
    private static final int MAX_NAME_LENGTH = 8;
    private static final ImageIcon BLANK_ICON = JerooIcons.landIcon;
    private JLabel flowerLabel = new JLabel();
    private JLabel nameLabel = new JLabel();
    private JButton imageButton = new JButton();
    private JButton flowerButton = new JButton();
    private Jeroo jeroo;
    private NumberFormat flowerFormat = NumberFormat.getIntegerInstance();

    public JerooStatusView() {
        this.flowerFormat.setMinimumIntegerDigits(2);
        this.flowerButton.setBorderPainted(false);
        this.flowerButton.setMargin(new Insets(0, 0, 0, 0));
        this.flowerButton.setEnabled(false);
        this.flowerButton.setDisabledIcon(JerooIcons.flowerIcon);
        this.flowerButton.setIcon(JerooIcons.flowerIcon);
        this.flowerLabel.setText("[??]");
        this.nameLabel.setText("unknown");
        this.imageButton.setBorderPainted(false);
        this.imageButton.setMargin(new Insets(0, 0, 0, 0));
        this.imageButton.setEnabled(false);
        this.imageButton.setDisabledIcon(BLANK_ICON);
        this.imageButton.setIcon(BLANK_ICON);
        this.setLayout(new FlowLayout(0));
        this.add(this.imageButton);
        this.add(this.nameLabel);
        this.add(this.flowerButton);
        this.add(this.flowerLabel);
    }

    public void addJeroo(Jeroo jeroo) {
        this.jeroo = jeroo;
        this.jeroo.addPropertyChangeListener("Jeroo Property", this);
        String string = this.jeroo.getName();
        if (string.length() <= 8) {
            for (int i = string.length(); i < 8; ++i) {
                string = string + " ";
            }
        } else {
            string = string.substring(0, 8);
        }
        this.nameLabel.setText(string);
        this.updateView();
    }

    public void updateView() {
        long l = this.jeroo.getFlowers();
        this.flowerLabel.setText("[" + this.flowerFormat.format(l) + "]");
        this.imageButton.setIcon(this.jeroo.getIcon());
        this.imageButton.setDisabledIcon(this.jeroo.getIcon());
    }

    @Override
    public Insets getInsets() {
        return new Insets(3, 3, 3, 3);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("Jeroo Property")) {
            this.updateView();
        }
    }
}

