/*
 * Decompiled with CFR 0.152.
 */
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class LanguageStyleManager {
    private static LanguageStyleManager instance = new LanguageStyleManager();
    public static final int JAVA_STYLE_CODE = 0;
    public static final int VB_STYLE_CODE = 1;
    public static final int PYTHON_STYLE_CODE = 2;
    private static final LanguageStyle[] styleAry = new LanguageStyle[]{new JavaStyle(), new VBStyle(), new PythonStyle()};
    private int currentStyleCode = 0;
    private int preferredStyleCode = 0;
    private PropertyChangeSupport changeReporter = new PropertyChangeSupport(this);

    private LanguageStyleManager() {
    }

    public static LanguageStyleManager getInstance() {
        return instance;
    }

    public LanguageStyle getCurrentStyle() {
        return styleAry[this.currentStyleCode];
    }

    public void setCurrentStyle(int n) {
        if (this.currentStyleCode != n) {
            int n2 = this.currentStyleCode;
            this.currentStyleCode = n;
            this.changeReporter.firePropertyChange("Current Style Property", new Integer(n2), new Integer(n));
        }
    }

    public LanguageStyle getPreferredStyle() {
        return styleAry[this.preferredStyleCode];
    }

    public void setPreferredStyle(int n) {
        this.preferredStyleCode = n;
    }

    public int getPreferredStyleCode() {
        return this.preferredStyleCode;
    }

    public int getCurrentStyleCode() {
        return this.currentStyleCode;
    }

    public String[] getStyleNames() {
        String[] stringArray = new String[styleAry.length];
        for (int i = 0; i < styleAry.length; ++i) {
            stringArray[i] = styleAry[i].getName();
        }
        return stringArray;
    }

    public String[] getSourcePrefixes() {
        String[] stringArray = new String[styleAry.length];
        for (int i = 0; i < styleAry.length; ++i) {
            stringArray[i] = styleAry[i].getSourcePrefix();
        }
        return stringArray;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeReporter.addPropertyChangeListener(propertyChangeListener);
    }
}

