/*
 * Decompiled with CFR 0.152.
 */
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LanguageStylePanel
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private JComboBox styleCombo;
    private static LanguageStylePanel instance = new LanguageStylePanel();
    private String[] styleAry;
    private LanguageStyleManager styleMgr = LanguageStyleManager.getInstance();

    private LanguageStylePanel() {
        this.styleAry = this.styleMgr.getStyleNames();
        this.styleCombo = new JComboBox<String>(this.styleAry);
        this.setLayout(new FlowLayout(1));
        this.add(new JLabel("Current Language Style"));
        this.add(this.styleCombo);
        this.styleCombo.setEditable(false);
        this.styleCombo.addActionListener(this);
        this.styleMgr.addPropertyChangeListener(this);
    }

    public static LanguageStylePanel getInstance() {
        return instance;
    }

    public void setStyle(int n) {
        this.styleCombo.setSelectedIndex(n);
    }

    public void setStyle(String string) {
        this.styleCombo.setSelectedItem(string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.styleCombo) {
            this.styleMgr.setCurrentStyle(this.styleCombo.getSelectedIndex());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("Current Style Property")) {
            int n = (Integer)propertyChangeEvent.getNewValue();
            this.styleCombo.setSelectedIndex(n);
        }
    }
}

