/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Hashtable;

public abstract class LexicalAnalyzer
implements Symbols {
    protected Hashtable rwSymbols = new Hashtable();
    protected Hashtable chSymbols;
    protected FileReader sourceReader;
    protected StreamTokenizer tokenizer;
    protected int sourceLineNum;
    protected String lastIdentifier;
    protected String lastSourceWord;
    protected int lastNumValue;
    protected int currPane;
    protected int paneLineNum;
    protected String sourceFileHeader;
    protected boolean caseSensitive;

    public LexicalAnalyzer(String string, String string2) throws FileNotFoundException {
        this.rwSymbols.put("while", WHILESYM);
        this.rwSymbols.put("if", IFSYM);
        this.rwSymbols.put("else", ELSESYM);
        this.rwSymbols.put("hasFlower", HASFLWR);
        this.rwSymbols.put("isNet", ISNET);
        this.rwSymbols.put("isFlower", ISFLWR);
        this.rwSymbols.put("isWater", ISWATER);
        this.rwSymbols.put("isJeroo", ISJEROO);
        this.rwSymbols.put("isFacing", FACING);
        this.rwSymbols.put("isClear", ISCLEAR);
        this.rwSymbols.put("give", GIVE);
        this.rwSymbols.put("plant", PLANT);
        this.rwSymbols.put("hop", HOP);
        this.rwSymbols.put("toss", TOSS);
        this.rwSymbols.put("pick", PICK);
        this.rwSymbols.put("turn", TURN);
        this.rwSymbols.put("RIGHT", RIGHT);
        this.rwSymbols.put("LEFT", LEFT);
        this.rwSymbols.put("AHEAD", AHEAD);
        this.rwSymbols.put("HERE", HERE);
        this.rwSymbols.put("NORTH", NORTH);
        this.rwSymbols.put("SOUTH", SOUTH);
        this.rwSymbols.put("WEST", WEST);
        this.rwSymbols.put("EAST", EAST);
        this.rwSymbols.put("new", NEWSYM);
        this.rwSymbols.put("Jeroo", JEROOSYM);
        this.chSymbols = new Hashtable();
        this.chSymbols.put(new Character('.'), MEMBERSELECT);
        this.chSymbols.put(new Character('('), LPAREN);
        this.chSymbols.put(new Character(')'), RPAREN);
        this.chSymbols.put(new Character(','), COMMA);
        this.chSymbols.put(new Character('='), ASSIGN);
        this.sourceReader = new FileReader(string);
        this.tokenizer = new StreamTokenizer(this.sourceReader);
        this.sourceFileHeader = string2;
        this.currPane = 1;
        this.paneLineNum = 0;
        this.sourceLineNum = 0;
        this.addReservedWords();
        this.addSymbols();
        this.configureStreamTokenizer();
    }

    protected abstract boolean isValidIdentifier(String var1);

    protected abstract void addReservedWords();

    protected abstract void addSymbols();

    protected abstract void configureStreamTokenizer();

    public Integer getSym() throws IOException {
        int n = this.tokenizer.nextToken();
        if (this.tokenizer.ttype == -3) {
            this.lastSourceWord = this.tokenizer.sval;
            String string = this.caseSensitive ? this.lastSourceWord : this.lastSourceWord.toUpperCase();
            Integer n2 = (Integer)this.rwSymbols.get(string);
            if (n2 != null) {
                return n2;
            }
            if (this.isValidIdentifier(string)) {
                this.lastIdentifier = string;
                return IDENT;
            }
            if (string.equals(this.sourceFileHeader)) {
                while (this.tokenizer.nextToken() != 10) {
                }
                this.tokenizer.pushBack();
                return FILEHEADER;
            }
            if (string.equals("@@")) {
                this.currPane = 0;
                this.paneLineNum = 0;
                while (this.tokenizer.nextToken() != 10) {
                }
                this.tokenizer.pushBack();
                return METHODSEP;
            }
            return ILLEGALWORD;
        }
        if (this.tokenizer.ttype == -2) {
            this.lastNumValue = (int)this.tokenizer.nval;
            return INTSYM;
        }
        if (n == 10) {
            ++this.sourceLineNum;
            ++this.paneLineNum;
            return this.getSym();
        }
        if (n == -1) {
            this.sourceReader.close();
            return ENDFILE;
        }
        Character c = new Character((char)n);
        Integer n3 = (Integer)this.chSymbols.get(c);
        if (n3 != null) {
            return n3;
        }
        return ILLEGALSYM;
    }

    public String getLastIdentifier() {
        return this.lastIdentifier;
    }

    public String getLastSourceWord() {
        return this.lastSourceWord;
    }

    public int getLastNumber() {
        return this.lastNumValue;
    }

    public int getCurrPane() {
        return this.currPane;
    }

    public int getRelativeLine() {
        return this.paneLineNum;
    }

    public void pushBack() {
        this.tokenizer.pushBack();
    }

    public Integer peekAhead() throws IOException {
        Integer n = this.getSym();
        this.pushBack();
        return n;
    }

    public void closeFile() {
        try {
            this.sourceReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

