/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class LoginDialog
extends JDialog
implements ActionListener {
    private Container loginPane;
    private JTextArea instructionArea = new JTextArea();
    private JPanel instructionPanel = new JPanel();
    private JPanel inputPanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private JButton continueButton = new JButton(" Continue ");
    private JButton cancelButton = new JButton(" End Program ");
    private LabeledTextField nameField = new LabeledTextField("Name", 7, 25);
    private LabeledTextField courseField = new LabeledTextField("Course", 7, 25);
    private LabeledTextField projectField = new LabeledTextField("Projects", 7, 25);
    private String name;
    private String course;
    private String project;
    private boolean choiceIsContinue = false;

    public LoginDialog(String string, String string2, String string3) {
        super((Frame)null, "Jeroo Login", true);
        this.instructionPanel.setLayout(new BoxLayout(this.instructionPanel, 0));
        this.instructionPanel.add(new PictureComponent(JerooIcons.jerooLogoIcon));
        this.instructionPanel.add(this.instructionArea);
        this.instructionArea.setBackground(new Color(0, 0, 0, 0));
        this.instructionArea.setEditable(false);
        this.instructionArea.setText("     These values will help identify anything you print.\n     Jeroo only requires your name.");
        this.instructionPanel.add(new PictureComponent(JerooIcons.jerooLogoIcon));
        this.inputPanel.setLayout(new BoxLayout(this.inputPanel, 1));
        this.inputPanel.add(this.nameField);
        this.nameField.setText(string);
        this.inputPanel.add(this.courseField);
        this.courseField.setText(string2);
        this.inputPanel.add(this.projectField);
        this.projectField.setText(string3);
        this.inputPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Identification Fields", 2, 2));
        this.buttonPanel.add(this.continueButton);
        this.continueButton.setBorder(BorderFactory.createRaisedBevelBorder());
        this.continueButton.addActionListener(this);
        this.buttonPanel.add(this.cancelButton);
        this.cancelButton.setBorder(BorderFactory.createRaisedBevelBorder());
        this.cancelButton.addActionListener(this);
        this.loginPane = this.getContentPane();
        this.loginPane.setLayout(new BoxLayout(this.loginPane, 1));
        this.loginPane.add(Box.createVerticalStrut(7));
        this.loginPane.add(this.instructionPanel);
        this.loginPane.add(Box.createVerticalStrut(15));
        this.loginPane.add(this.inputPanel);
        this.loginPane.add(Box.createVerticalStrut(15));
        this.loginPane.add(this.buttonPanel);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.nameField.requestFocusInWindow();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getValue() {
        String string = " -- ";
        return this.name + string + this.course + string + this.project;
    }

    public boolean continueWasSelected() {
        return this.choiceIsContinue;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.continueButton) {
            this.name = this.nameField.getText();
            if (Pattern.matches(" *", this.name)) {
                this.choiceIsContinue = false;
                JOptionPane.showMessageDialog(null, "You must provide a name!", "Incomplete Login", 0);
            } else {
                this.course = this.courseField.getText();
                if (Pattern.matches(" *", this.course)) {
                    this.course = " ";
                }
                this.project = this.projectField.getText();
                if (Pattern.matches(" *", this.project)) {
                    this.project = " ";
                }
                this.choiceIsContinue = true;
                this.setVisible(false);
            }
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.choiceIsContinue = false;
            this.setVisible(false);
        }
    }
}

