/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class PreferencesInitDialog
extends JDialog
implements ActionListener {
    private FlowLayout leftFlow = new FlowLayout(0);
    private Container preferencesPane;
    private JPanel instructionPanel = new JPanel();
    private JPanel tabPanel = new JPanel();
    private JPanel autoIndentPanel = new JPanel();
    private JPanel stylePanel = new JPanel();
    private JPanel styleLabelPanel = new JPanel();
    private JPanel styleGroupPanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private JTextArea instructionArea = new JTextArea();
    private JLabel tabSizeLabel = new JLabel("Editor Tab Size");
    private JLabel[] styleLabel = new JLabel[]{new JLabel("Programming Style"), new JLabel(" (for new files)")};
    private JSlider tabSlider = new JSlider(0, 5);
    private JCheckBox autoIndentBox = new JCheckBox();
    private String[] styleNameAry;
    private ButtonGroup styleGroup = new ButtonGroup();
    private JRadioButton[] styleRadioAry;
    private JButton okButton = new JButton(" Remember These Preferences ");
    UserPreferences prefs = UserPreferences.getInstance();
    LanguageStyleManager styleMgr = LanguageStyleManager.getInstance();
    private boolean okSelected = false;

    public PreferencesInitDialog() {
        super((Frame)null, "Initialize Preferences", true);
        int n;
        this.styleNameAry = this.styleMgr.getStyleNames();
        this.prefs = UserPreferences.getInstance();
        this.prefs.setDefaults();
        this.instructionArea.setRows(4);
        this.instructionArea.setColumns(30);
        this.instructionArea.setText("There is no record of your personal preferences.\nPlease set your preferred tab size and programming style. \nWhen you are finished, press the \"Remember...\" button. \n");
        this.instructionArea.setEditable(false);
        this.instructionArea.setBackground(new Color(0, 0, 0, 0));
        this.instructionPanel.add(this.instructionArea);
        this.instructionPanel.setBorder(new EmptyBorder(0, 10, 0, 0));
        this.tabSlider.setPaintLabels(true);
        this.tabSlider.setPaintTicks(true);
        this.tabSlider.setMajorTickSpacing(1);
        this.tabSlider.setSnapToTicks(true);
        this.tabSlider.setValue(this.prefs.getTabSize());
        this.tabPanel.setLayout(this.leftFlow);
        this.tabPanel.add(this.tabSizeLabel);
        this.tabPanel.add(Box.createHorizontalStrut(50));
        this.autoIndentBox.setText("Auto-indent when typing  ");
        this.autoIndentBox.setHorizontalTextPosition(10);
        this.autoIndentBox.setSelected(this.prefs.autoIndentIsSet());
        this.autoIndentPanel.setLayout(this.leftFlow);
        this.autoIndentPanel.add(this.autoIndentBox);
        this.tabPanel.add(this.tabSlider);
        this.styleLabelPanel.setLayout(new BoxLayout(this.styleLabelPanel, 1));
        this.styleLabelPanel.setBorder(new EmptyBorder(0, 0, 20, 0));
        this.styleLabelPanel.add(this.styleLabel[0]);
        this.styleLabelPanel.add(this.styleLabel[1]);
        this.styleRadioAry = new JRadioButton[this.styleNameAry.length];
        for (n = 0; n < this.styleNameAry.length; ++n) {
            this.styleRadioAry[n] = new JRadioButton(this.styleNameAry[n]);
            this.styleRadioAry[n].setActionCommand(String.valueOf(n));
            this.styleGroup.add(this.styleRadioAry[n]);
            if (this.prefs.getStyleCode() != n) continue;
            this.styleRadioAry[n].setSelected(true);
        }
        this.styleGroupPanel.setLayout(new BoxLayout(this.styleGroupPanel, 1));
        for (n = 0; n < this.styleRadioAry.length; ++n) {
            this.styleGroupPanel.add(this.styleRadioAry[n]);
        }
        this.styleGroupPanel.setBorder(new CompoundBorder(BorderFactory.createEtchedBorder(), new EmptyBorder(5, 5, 5, 5)));
        this.stylePanel.setLayout(this.leftFlow);
        this.stylePanel.add(this.styleLabelPanel);
        this.stylePanel.add(Box.createHorizontalStrut(26));
        this.stylePanel.add(this.styleGroupPanel);
        this.buttonPanel.add(Box.createHorizontalStrut(5));
        this.buttonPanel.add(this.okButton);
        this.okButton.setBorder(BorderFactory.createRaisedBevelBorder());
        this.okButton.addActionListener(this);
        this.buttonPanel.add(Box.createHorizontalStrut(5));
        this.preferencesPane = this.getContentPane();
        this.preferencesPane.setLayout(new BoxLayout(this.preferencesPane, 1));
        this.preferencesPane.add(Box.createVerticalStrut(5));
        this.preferencesPane.add(this.instructionPanel);
        this.preferencesPane.add(Box.createVerticalStrut(5));
        this.preferencesPane.add(this.tabPanel);
        this.preferencesPane.add(Box.createVerticalStrut(5));
        this.preferencesPane.add(this.autoIndentPanel);
        this.preferencesPane.add(Box.createVerticalStrut(5));
        this.preferencesPane.add(this.stylePanel);
        this.preferencesPane.add(Box.createVerticalStrut(10));
        this.preferencesPane.add(this.buttonPanel);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(null);
    }

    public boolean choiceIsSave() {
        return this.okSelected;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.okSelected = true;
            int n = this.tabSlider.getValue();
            String string = this.styleGroup.getSelection().getActionCommand();
            this.prefs.setPref("TabSize", n + "");
            this.prefs.setPref("AutoIndent", this.autoIndentBox.isSelected() + "");
            this.prefs.setPref("LanguageStyle", string);
            this.styleMgr.setPreferredStyle(Integer.parseInt(string));
        }
        this.setVisible(false);
    }
}

