/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class PreferencesModifyDialog
extends JDialog
implements ActionListener {
    private FlowLayout leftFlow = new FlowLayout(0);
    private Container preferencesPane;
    private JPanel tabPanel = new JPanel();
    private JPanel autoIndentPanel = new JPanel();
    private JPanel stylePanel = new JPanel();
    private JPanel styleLabelPanel = new JPanel();
    private JPanel styleGroupPanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private JLabel tabSizeLabel = new JLabel("Editor Tab Size");
    private JLabel[] styleLabel = new JLabel[]{new JLabel("Programming Style"), new JLabel(" (for new files)")};
    private JSlider tabSlider = new JSlider(0, 5);
    private JCheckBox autoIndentBox = new JCheckBox();
    private String[] styleNameAry;
    private ButtonGroup styleGroup = new ButtonGroup();
    private JRadioButton[] styleRadioAry;
    private JButton saveButton = new JButton(" Save These Preferences ");
    private JButton cancelButton = new JButton(" Don't Change Preferences ");
    UserPreferences prefs;
    LanguageStyleManager styleMgr;
    private boolean saveSelected;

    public PreferencesModifyDialog(UserPreferences userPreferences) {
        super((Frame)null, "View/Change Preferences", true);
        int n;
        this.prefs = userPreferences;
        this.styleMgr = LanguageStyleManager.getInstance();
        this.styleNameAry = this.styleMgr.getStyleNames();
        this.saveSelected = false;
        this.tabSlider.setPaintLabels(true);
        this.tabSlider.setPaintTicks(true);
        this.tabSlider.setMajorTickSpacing(1);
        this.tabSlider.setSnapToTicks(true);
        this.tabSlider.setValue(userPreferences.getTabSize());
        this.tabPanel.setLayout(this.leftFlow);
        this.tabPanel.add(this.tabSizeLabel);
        this.tabPanel.add(Box.createHorizontalStrut(50));
        this.tabPanel.add(this.tabSlider);
        this.autoIndentBox.setText("Auto-indent when typing  ");
        this.autoIndentBox.setHorizontalTextPosition(10);
        this.autoIndentBox.setSelected(userPreferences.autoIndentIsSet());
        this.autoIndentPanel.setLayout(this.leftFlow);
        this.autoIndentPanel.add(this.autoIndentBox);
        this.styleLabelPanel.setLayout(new BoxLayout(this.styleLabelPanel, 1));
        this.styleLabelPanel.setBorder(new EmptyBorder(0, 0, 20, 0));
        this.styleLabelPanel.add(this.styleLabel[0]);
        this.styleLabelPanel.add(this.styleLabel[1]);
        this.styleRadioAry = new JRadioButton[this.styleNameAry.length];
        for (n = 0; n < this.styleNameAry.length; ++n) {
            this.styleRadioAry[n] = new JRadioButton(this.styleNameAry[n]);
            this.styleRadioAry[n].setActionCommand(String.valueOf(n));
            this.styleGroup.add(this.styleRadioAry[n]);
            if (userPreferences.getStyleCode() != n) continue;
            this.styleRadioAry[n].setSelected(true);
        }
        this.styleGroupPanel.setLayout(new BoxLayout(this.styleGroupPanel, 1));
        for (n = 0; n < this.styleRadioAry.length; ++n) {
            this.styleGroupPanel.add(this.styleRadioAry[n]);
        }
        this.styleGroupPanel.setBorder(new CompoundBorder(BorderFactory.createEtchedBorder(), new EmptyBorder(5, 5, 5, 5)));
        this.stylePanel.setLayout(this.leftFlow);
        this.stylePanel.add(this.styleLabelPanel);
        this.stylePanel.add(Box.createHorizontalStrut(26));
        this.stylePanel.add(this.styleGroupPanel);
        this.buttonPanel.add(Box.createHorizontalStrut(5));
        this.buttonPanel.add(this.saveButton);
        this.saveButton.setBorder(BorderFactory.createRaisedBevelBorder());
        this.saveButton.addActionListener(this);
        this.buttonPanel.add(Box.createHorizontalStrut(5));
        this.buttonPanel.add(this.cancelButton);
        this.cancelButton.setBorder(BorderFactory.createRaisedBevelBorder());
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add(Box.createHorizontalStrut(5));
        this.preferencesPane = this.getContentPane();
        this.preferencesPane.setLayout(new BoxLayout(this.preferencesPane, 1));
        this.preferencesPane.add(Box.createVerticalStrut(5));
        this.preferencesPane.add(this.tabPanel);
        this.preferencesPane.add(Box.createVerticalStrut(5));
        this.preferencesPane.add(this.autoIndentPanel);
        this.preferencesPane.add(Box.createVerticalStrut(5));
        this.preferencesPane.add(this.stylePanel);
        this.preferencesPane.add(Box.createVerticalStrut(10));
        this.preferencesPane.add(this.buttonPanel);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(null);
    }

    public boolean choiceIsSave() {
        return this.saveSelected;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.saveButton) {
            this.saveSelected = true;
            int n = this.tabSlider.getValue();
            boolean bl = this.autoIndentBox.isSelected();
            String string = this.styleGroup.getSelection().getActionCommand();
            this.prefs.setPref("TabSize", n + "");
            this.prefs.setPref("AutoIndent", bl + "");
            this.prefs.setPref("LanguageStyle", string);
            this.styleMgr.setPreferredStyle(Integer.parseInt(string));
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.saveSelected = false;
        }
        this.setVisible(false);
    }
}

