/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.util.Stack;
import javax.swing.ImageIcon;

public class Processor {
    private InstructionMemory iMem;
    private SantongModel eMem;
    private Stack callStack;
    private Jeroo[] jerooMem;
    private int currentJerooRegister;
    private Stack comparisonStack;
    private int pc;
    private Instruction ir;
    private int instructionsExecuted;
    private boolean firstInst;
    private int lastLine;
    private int lastPane;
    private String lastInst;
    private JerooNameTable jerooNames = JerooNameTable.getInstance();
    private ImageIcon[][] jerooIcons = new ImageIcon[][]{JerooIcons.jeroo_0_IconArray, JerooIcons.jeroo_1_IconArray, JerooIcons.jeroo_2_IconArray, JerooIcons.jeroo_3_IconArray};

    public Processor(String string, SantongModel santongModel) throws Exception {
        this.iMem = new InstructionMemory(string);
        this.eMem = santongModel;
        this.callStack = new Stack();
        this.jerooMem = new Jeroo[4];
        this.callStack.push(new Integer(0));
        this.comparisonStack = new Stack();
        this.pc = 0;
        this.instructionsExecuted = 0;
        this.firstInst = true;
    }

    public void fetchInstruction() throws Exception {
        if (!this.firstInst) {
            this.lastLine = this.ir.arg7;
            this.lastPane = this.ir.arg6;
            this.lastInst = this.ir.op;
        }
        this.ir = this.iMem.getInstruction(this.pc);
        ++this.pc;
        this.firstInst = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeInstruction() throws Exception {
        String string = this.ir.op;
        if (string.equals("CSR")) {
            this.currentJerooRegister = this.ir.arg1;
        } else if (string.equals("JUMP")) {
            this.pc = this.ir.arg1;
        } else if (string.equals("BZ")) {
            if ((Integer)this.comparisonStack.pop() == 0) {
                this.pc = this.ir.arg1;
            }
        } else if (string.equals("NEW")) {
            if (this.ir.arg1 >= 4) throw new JerooException("Processor Error: Jeroo ID outside bounds", this.ir.arg7, JerooConstants.PANE_NAME[this.ir.arg6]);
            Point point = new Point(this.ir.arg2, this.ir.arg3);
            try {
                this.jerooMem[this.ir.arg1] = new Jeroo(this.eMem, this.jerooNames.getName(this.ir.arg1), this.jerooIcons[this.ir.arg1], point, this.ir.arg4, this.ir.arg5);
            }
            catch (JerooException jerooException) {
                jerooException.setLineNum(this.ir.arg7);
                jerooException.setPane(JerooConstants.PANE_NAME[this.ir.arg6]);
                throw jerooException;
            }
        } else if (string.equals("TURN")) {
            this.jerooMem[this.currentJerooRegister].turn(this.ir.arg1);
        } else if (string.equals("HOP")) {
            try {
                if (this.ir.arg1 < 1) {
                    throw new JerooException("RUNTIME ERROR: Argument to hop(n) must be > 0.");
                }
                for (int i = 0; i < this.ir.arg1; ++i) {
                    this.jerooMem[this.currentJerooRegister].hop();
                }
            }
            catch (JerooException jerooException) {
                jerooException.setLineNum(this.ir.arg7);
                jerooException.setPane(JerooConstants.PANE_NAME[this.ir.arg6]);
                throw jerooException;
            }
        } else if (string.equals("TOSS")) {
            this.jerooMem[this.currentJerooRegister].toss();
        } else if (string.equals("PICK")) {
            this.jerooMem[this.currentJerooRegister].pick();
        } else if (string.equals("PLANT")) {
            this.jerooMem[this.currentJerooRegister].plant();
        } else if (string.equals("GIVE")) {
            this.jerooMem[this.currentJerooRegister].give(this.ir.arg1);
        } else if (string.equals("HASFLWR")) {
            if (this.jerooMem[this.currentJerooRegister].hasFlower()) {
                this.comparisonStack.push(new Integer(1));
            } else {
                this.comparisonStack.push(new Integer(0));
            }
        } else if (string.equals("ISFLWR")) {
            if (this.jerooMem[this.currentJerooRegister].isFlower(this.ir.arg1)) {
                this.comparisonStack.push(new Integer(1));
            } else {
                this.comparisonStack.push(new Integer(0));
            }
        } else if (string.equals("ISNET")) {
            if (this.jerooMem[this.currentJerooRegister].isNet(this.ir.arg1)) {
                this.comparisonStack.push(new Integer(1));
            } else {
                this.comparisonStack.push(new Integer(0));
            }
        } else if (string.equals("ISWATER")) {
            if (this.jerooMem[this.currentJerooRegister].isWater(this.ir.arg1)) {
                this.comparisonStack.push(new Integer(1));
            } else {
                this.comparisonStack.push(new Integer(0));
            }
        } else if (string.equals("ISJEROO")) {
            if (this.jerooMem[this.currentJerooRegister].isJeroo(this.ir.arg1)) {
                this.comparisonStack.push(new Integer(1));
            } else {
                this.comparisonStack.push(new Integer(0));
            }
        } else if (string.equals("FACING")) {
            if (this.jerooMem[this.currentJerooRegister].isFacing(this.ir.arg1)) {
                this.comparisonStack.push(new Integer(1));
            } else {
                this.comparisonStack.push(new Integer(0));
            }
        } else if (string.equals("NOT")) {
            if ((Integer)this.comparisonStack.pop() == 0) {
                this.comparisonStack.push(new Integer(1));
            } else {
                this.comparisonStack.push(new Integer(0));
            }
        } else if (string.equals("AND")) {
            if ((Integer)this.comparisonStack.pop() == 1 & (Integer)this.comparisonStack.pop() == 1) {
                this.comparisonStack.push(new Integer(1));
            } else {
                this.comparisonStack.push(new Integer(0));
            }
        } else if (string.equals("OR")) {
            if ((Integer)this.comparisonStack.pop() == 1 | (Integer)this.comparisonStack.pop() == 1) {
                this.comparisonStack.push(new Integer(1));
            } else {
                this.comparisonStack.push(new Integer(0));
            }
        } else if (string.equals("RETR")) {
            this.pc = (Integer)this.callStack.pop();
        } else {
            if (!string.equals("CALLBK")) throw new JerooException("Processor Error: Invalid Op Code");
            this.callStack.push(new Integer(this.pc + 1));
        }
        ++this.instructionsExecuted;
    }

    public int getOrigPane() {
        if (this.firstInst) {
            return -1;
        }
        return this.lastPane;
    }

    public int getOrigLine() {
        if (this.firstInst) {
            return 0;
        }
        return this.lastLine;
    }

    public SourceLineReference getOrigSourceRef() {
        int n;
        int n2;
        if (this.firstInst) {
            n2 = -1;
            n = 0;
        } else {
            n2 = this.lastPane;
            n = this.lastLine;
        }
        return new SourceLineReference(n2, n);
    }

    public SourceLineReference getNextSourceRef() {
        Instruction instruction = null;
        try {
            if (this.firstInst) {
                instruction = this.iMem.getInstruction(0);
                instruction = this.iMem.getInstruction(instruction.arg1);
            } else {
                instruction = this.ir;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new SourceLineReference(instruction.arg6, instruction.arg7);
    }

    public void runStep() throws Exception {
        if (!this.endOfProgram()) {
            this.fetchInstruction();
            this.executeInstruction();
        }
    }

    public boolean endOfProgram() {
        return this.pc == 0 && this.instructionsExecuted != 0;
    }

    public void executeSourceStatement() throws Exception {
        if (this.firstInst) {
            this.fetchInstruction();
        }
        do {
            this.executeInstruction();
            if (this.endOfProgram()) continue;
            this.fetchInstruction();
        } while (!this.endOfProgram() && (this.lastLine == this.ir.arg7 && this.lastPane == this.ir.arg6 || this.lastLine == 0 && this.lastPane == 1 || this.ir.arg6 == 2));
    }

    public void run() throws Exception {
        do {
            this.fetchInstruction();
            this.executeInstruction();
        } while (this.pc != 0);
    }
}

