/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Stack;

public class PythonLexicalAnalyzer
extends LexicalAnalyzer {
    private int lastIndentLevel;
    private int currIndentLevel;
    private boolean leadingSpace;
    private Stack indentLevels;

    public PythonLexicalAnalyzer(String string, String string2) throws FileNotFoundException {
        super(string, string2);
        this.caseSensitive = true;
        this.currIndentLevel = 0;
        this.leadingSpace = true;
        this.indentLevels = new Stack();
    }

    @Override
    protected boolean isValidIdentifier(String string) {
        char c = string.charAt(0);
        boolean bl = Character.isLetter(c);
        for (int i = 1; i < string.length(); ++i) {
            c = string.charAt(i);
            bl = bl && (Character.isLetterOrDigit(c) || c == '_');
        }
        return bl;
    }

    @Override
    protected void addReservedWords() {
        this.rwSymbols.put("def", DEFSYM);
        this.rwSymbols.put("self", SELFSYM);
        this.rwSymbols.put("and", ANDSYM);
        this.rwSymbols.put("or", ORSYM);
        this.rwSymbols.put("not", NOTSYM);
        this.rwSymbols.put("elif", ELSIFSYM);
    }

    @Override
    protected void addSymbols() {
        this.chSymbols.put(new Character(':'), COLON);
    }

    @Override
    protected void configureStreamTokenizer() {
        this.tokenizer.eolIsSignificant(true);
        this.tokenizer.slashSlashComments(false);
        this.tokenizer.slashStarComments(false);
        this.tokenizer.commentChar(35);
        this.tokenizer.ordinaryChar(47);
        this.tokenizer.ordinaryChar(46);
        this.tokenizer.ordinaryChar(32);
        this.tokenizer.wordChars(64, 64);
        this.tokenizer.wordChars(95, 95);
    }

    @Override
    public Integer getSym() throws IOException {
        int n = this.tokenizer.nextToken();
        if (!this.leadingSpace && ' ' == (char)n) {
            return this.getSym();
        }
        if (this.leadingSpace && ' ' == (char)n) {
            do {
                ++this.currIndentLevel;
            } while (' ' == (char)(n = this.tokenizer.nextToken()));
            this.tokenizer.pushBack();
            if (n != 10) {
                if (n != 10 && (this.indentLevels.empty() && this.currIndentLevel > 0 || this.currIndentLevel > (Integer)this.indentLevels.peek())) {
                    this.indentLevels.push(new Integer(this.currIndentLevel));
                }
                this.leadingSpace = false;
            }
            return this.getSym();
        }
        if (!this.indentLevels.empty() && this.currIndentLevel < (Integer)this.indentLevels.peek()) {
            this.tokenizer.pushBack();
            this.indentLevels.pop();
            return ENDSYM;
        }
        if (n == 10) {
            this.leadingSpace = true;
            this.currIndentLevel = 0;
        } else {
            this.leadingSpace = false;
        }
        this.tokenizer.pushBack();
        return super.getSym();
    }
}

