/*
 * Decompiled with CFR 0.152.
 */
import javax.swing.SwingUtilities;

public class RunThread
extends Thread {
    private final long pauseWait = 100L;
    private Processor jerooProcessor;
    private JerooGUI theGUI;
    private SourceLineReference nextSourceRef;
    private long delayTime;
    private volatile boolean okToRun;
    private volatile boolean paused;
    private volatile boolean continuousMode;
    private volatile boolean stepRequested;

    public RunThread(Processor processor, JerooGUI jerooGUI, long l, boolean bl) {
        super("EXECUTION THREAD");
        this.jerooProcessor = processor;
        this.theGUI = jerooGUI;
        this.delayTime = l;
        this.continuousMode = bl;
        this.okToRun = true;
        this.paused = false;
        this.stepRequested = false;
    }

    @Override
    public void run() {
        try {
            Runnable runnable;
            while (!this.jerooProcessor.endOfProgram()) {
                this.nextSourceRef = this.jerooProcessor.getNextSourceRef();
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        RunThread.this.theGUI.updateNextSource(RunThread.this.nextSourceRef);
                    }
                };
                SwingUtilities.invokeLater(runnable);
                if (this.continuousMode) {
                    while (this.paused && this.okToRun && this.continuousMode) {
                        Thread.sleep(100L);
                    }
                    if (!this.okToRun) break;
                    if (this.continuousMode) {
                        Thread.sleep(this.delayTime);
                    } else {
                        this.stepRequested = false;
                    }
                    this.jerooProcessor.executeSourceStatement();
                    continue;
                }
                while (this.okToRun && !this.stepRequested && !this.continuousMode) {
                    Thread.sleep(100L);
                }
                if (!this.okToRun) break;
                this.stepRequested = false;
                this.jerooProcessor.executeSourceStatement();
            }
            if (this.okToRun) {
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        RunThread.this.theGUI.finishRunNormally();
                    }
                };
                SwingUtilities.invokeLater(runnable);
            } else {
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        RunThread.this.theGUI.finishRunByUser();
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }
        catch (Exception exception) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    RunThread.this.theGUI.finishRunByException(exception.getMessage());
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void pauseRun() {
        this.paused = true;
    }

    public void performStep() {
        this.stepRequested = true;
        this.continuousMode = false;
    }

    public void resumeRun() {
        this.paused = false;
        this.continuousMode = true;
    }

    public void stopRun() {
        this.okToRun = false;
    }

    public void setDelayTime(long l) {
        this.delayTime = l;
    }
}

