/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class SantongModel
implements Serializable,
MenuListener {
    private int islandRows;
    private int islandCols;
    private IslandComponent[][] islandMap;
    private OceanComponent[] northernSea;
    private OceanComponent[] southernSea;
    private OceanComponent[] westernOcean;
    private OceanComponent[] easternOcean;
    private boolean isEditable = false;
    private JerooFlagManager flagMgr = JerooFlagManager.getInstance();
    private boolean changeStatus;
    private SantongComponentEditor componentEditor = new SantongComponentEditor();
    private Vector flowerComponents = new Vector();
    private Vector netComponents = new Vector();
    private Vector waterComponents = new Vector();

    public SantongModel() {
        this(24, 24);
    }

    public SantongModel(int n, int n2) {
        int n3;
        this.islandRows = n;
        this.islandCols = n2;
        this.islandMap = new IslandComponent[n][n2];
        for (n3 = 0; n3 < n; ++n3) {
            for (int i = 0; i < n2; ++i) {
                this.islandMap[n3][i] = new IslandComponent(new Point(n3, i));
                this.islandMap[n3][i].addMouseListener(this.componentEditor);
                this.islandMap[n3][i].addMouseMotionListener(this.componentEditor);
            }
        }
        this.northernSea = new OceanComponent[n2 + 2];
        this.southernSea = new OceanComponent[n2 + 2];
        this.westernOcean = new OceanComponent[n];
        this.easternOcean = new OceanComponent[n];
        for (n3 = 0; n3 < n2 + 2; ++n3) {
            this.northernSea[n3] = new OceanComponent(new Point(-1, n3 - 1));
            this.northernSea[n3].addMouseListener(this.componentEditor);
            this.northernSea[n3].addMouseMotionListener(this.componentEditor);
            this.southernSea[n3] = new OceanComponent(new Point(n, n3 - 1));
            this.southernSea[n3].addMouseListener(this.componentEditor);
            this.southernSea[n3].addMouseMotionListener(this.componentEditor);
        }
        for (n3 = 0; n3 < n; ++n3) {
            this.westernOcean[n3] = new OceanComponent(new Point(n3, -1));
            this.westernOcean[n3].addMouseListener(this.componentEditor);
            this.westernOcean[n3].addMouseMotionListener(this.componentEditor);
            this.easternOcean[n3] = new OceanComponent(new Point(n3, n2));
            this.easternOcean[n3].addMouseListener(this.componentEditor);
            this.easternOcean[n3].addMouseMotionListener(this.componentEditor);
        }
        this.componentEditor.setActiveState(false);
        this.flagMgr.setFlag(2, false);
        this.changeStatus = false;
    }

    public void addFlowers() {
        this.componentEditor.addFlowers();
    }

    public void addNets() {
        this.componentEditor.addNets();
    }

    public void addWater() {
        this.componentEditor.addWater();
    }

    public void clear() {
        int n;
        for (n = 0; n < this.islandRows; ++n) {
            for (int i = 0; i < this.islandCols; ++i) {
                this.islandMap[n][i].removeFlower();
                this.islandMap[n][i].removeNet();
                this.islandMap[n][i].removeJeroo();
                this.islandMap[n][i].removeWater();
            }
        }
        for (n = 0; n < this.islandCols + 2; ++n) {
            this.northernSea[n].removeJeroo();
            this.southernSea[n].removeJeroo();
        }
        for (n = 0; n < this.islandRows; ++n) {
            this.westernOcean[n].removeJeroo();
            this.easternOcean[n].removeJeroo();
        }
        this.flagMgr.setFlag(2, true);
    }

    public void clearUnsavedChanges() {
        this.flagMgr.setFlag(2, false);
    }

    public SantongComponent componentAt(int n, int n2) throws IndexOutOfBoundsException {
        if (this.hasIslandLocation(n, n2)) {
            return this.islandMap[n][n2];
        }
        if (this.hasNorthernSeaLocation(n, n2)) {
            return this.northernSea[n2 + 1];
        }
        if (this.hasSouthernSeaLocation(n, n2)) {
            return this.southernSea[n2 + 1];
        }
        if (this.hasWesternOceanLocation(n, n2)) {
            return this.westernOcean[n];
        }
        if (this.hasEasternOceanLocation(n, n2)) {
            return this.easternOcean[n];
        }
        throw new IndexOutOfBoundsException("The location [" + n + "][" + n2 + "] is invalid");
    }

    public SantongComponent componentAt(Point point) throws IndexOutOfBoundsException {
        return this.componentAt((int)point.getX(), (int)point.getY());
    }

    public Iterator components() {
        int n;
        Vector<SantongComponent> vector = new Vector<SantongComponent>();
        for (n = 0; n < this.islandCols + 2; ++n) {
            vector.addElement(this.northernSea[n]);
        }
        for (n = 0; n < this.islandRows; ++n) {
            vector.addElement(this.westernOcean[n]);
            for (int i = 0; i < this.islandCols; ++i) {
                vector.addElement(this.islandMap[n][i]);
            }
            vector.addElement(this.easternOcean[n]);
        }
        for (n = 0; n < this.islandCols + 2; ++n) {
            vector.addElement(this.southernSea[n]);
        }
        return vector.iterator();
    }

    public int getCols() {
        return this.islandCols + 2;
    }

    public Vector getFlowerComponents() {
        Vector<IslandComponent> vector = new Vector<IslandComponent>();
        for (int i = 0; i < this.islandRows; ++i) {
            for (int j = 0; j < this.islandCols; ++j) {
                if (!this.islandMap[i][j].hasFlower()) continue;
                vector.addElement(this.islandMap[i][j]);
            }
        }
        return vector;
    }

    public Vector getNetComponents() {
        Vector<IslandComponent> vector = new Vector<IslandComponent>();
        for (int i = 0; i < this.islandRows; ++i) {
            for (int j = 0; j < this.islandCols; ++j) {
                if (!this.islandMap[i][j].hasNet()) continue;
                vector.addElement(this.islandMap[i][j]);
            }
        }
        return vector;
    }

    public Vector getWaterComponents() {
        Vector<IslandComponent> vector = new Vector<IslandComponent>();
        for (int i = 0; i < this.islandRows; ++i) {
            for (int j = 0; j < this.islandCols; ++j) {
                if (!this.islandMap[i][j].hasWater()) continue;
                vector.addElement(this.islandMap[i][j]);
            }
        }
        return vector;
    }

    public int getRows() {
        return this.islandRows + 2;
    }

    public boolean hasIslandLocation(int n, int n2) {
        return 0 <= n && n < this.islandRows && 0 <= n2 && n2 < this.islandCols;
    }

    public boolean hasIslandLocation(Point point) {
        return this.hasIslandLocation((int)point.getX(), (int)point.getY());
    }

    public boolean hasUnsavedChanges() {
        return this.flagMgr.isSet(2);
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void openFile(File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        this.clear();
        for (int i = 0; i < this.islandRows; ++i) {
            String string = bufferedReader.readLine();
            for (int j = 0; j < this.islandCols; ++j) {
                char c = string.charAt(j);
                if (c == 'F') {
                    this.islandMap[i][j].addFlower();
                    continue;
                }
                if (c == 'N') {
                    this.islandMap[i][j].addNet();
                    continue;
                }
                if (c != 'W') continue;
                this.islandMap[i][j].addWater();
            }
        }
        bufferedReader.close();
        this.clearUnsavedChanges();
    }

    public void recordState() {
        this.flowerComponents = this.getFlowerComponents();
        this.netComponents = this.getNetComponents();
        this.waterComponents = this.getWaterComponents();
        this.changeStatus = this.flagMgr.isSet(2);
    }

    public void reset() {
        this.clear();
        for (IslandComponent islandComponent : this.flowerComponents) {
            islandComponent.addFlower();
        }
        for (IslandComponent islandComponent : this.netComponents) {
            islandComponent.addNet();
        }
        for (IslandComponent islandComponent : this.waterComponents) {
            islandComponent.addWater();
        }
        this.flagMgr.setFlag(2, this.changeStatus);
    }

    public void saveToFile(File file) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        for (int i = 0; i < this.islandRows; ++i) {
            for (int j = 0; j < this.islandCols; ++j) {
                IslandComponent islandComponent = this.islandMap[i][j];
                if (islandComponent.hasFlower()) {
                    bufferedWriter.write("F");
                    continue;
                }
                if (islandComponent.hasNet()) {
                    bufferedWriter.write("N");
                    continue;
                }
                if (islandComponent.hasWater()) {
                    bufferedWriter.write("W");
                    continue;
                }
                bufferedWriter.write(".");
            }
            bufferedWriter.write("\n");
        }
        bufferedWriter.flush();
        bufferedWriter.close();
        this.clearUnsavedChanges();
    }

    public void setEditable(boolean bl) {
        this.isEditable = bl;
        this.componentEditor.setActiveState(bl);
    }

    public void setUnsavedChanges(boolean bl) {
        this.flagMgr.setFlag(2, bl);
    }

    protected boolean hasNorthernSeaLocation(int n, int n2) {
        return n == -1 && 0 <= n2 && n2 < this.islandCols + 2;
    }

    protected boolean hasSouthernSeaLocation(int n, int n2) {
        return n == this.islandRows && 0 <= n2 && n2 < this.islandCols + 2;
    }

    protected boolean hasWesternOceanLocation(int n, int n2) {
        return n2 == -1 && 0 <= n && n < this.islandRows;
    }

    protected boolean hasEasternOceanLocation(int n, int n2) {
        return n2 == this.islandCols && 0 <= n && n < this.islandRows;
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        this.componentEditor.setMenuSelected(true);
    }
}

