/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Iterator;
import javax.swing.JPanel;

public class SantongView
extends JPanel
implements MouseListener,
Serializable {
    private SantongModel model;
    private int numRows;
    private int numCols;
    private int viewWidth;
    private int viewHeight;
    private SantongCursorListener cursorListener;

    public SantongView(int n, int n2) {
        this(new SantongModel(), n, n2);
    }

    public SantongView(SantongModel santongModel, int n, int n2) {
        this.model = santongModel;
        this.numRows = this.model.getRows();
        this.numCols = this.model.getCols();
        this.viewWidth = n;
        this.viewHeight = n2;
        this.cursorListener = new SantongCursorListener();
        this.setLayout(new GridLayout(this.numRows, this.numCols, 0, 0));
        this.setSize(n, n2);
        this.setMinimumSize(new Dimension(n, n2));
        this.setMaximumSize(new Dimension(n, n2));
        this.setPreferredSize(new Dimension(n, n2));
        this.setBackground(Color.BLUE);
        Iterator iterator = this.model.components();
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                SantongComponent santongComponent = (SantongComponent)iterator.next();
                this.add(santongComponent);
                santongComponent.addPropertyChangeListener("Entered Property", this.cursorListener);
                santongComponent.repaint();
            }
        }
    }

    @Override
    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public SantongModel getModel() {
        return this.model;
    }

    public void print(String string, String string2) {
        SantongViewPrinter santongViewPrinter = new SantongViewPrinter();
        santongViewPrinter.print(string, string2, this);
    }

    public void replaceModel(SantongModel santongModel) {
        this.model = santongModel;
        Iterator iterator = this.model.components();
        this.removeAll();
        this.numRows = this.model.getRows();
        this.numCols = this.model.getCols();
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                SantongComponent santongComponent = (SantongComponent)iterator.next();
                this.add(santongComponent);
                santongComponent.addPropertyChangeListener("Entered Property", this.cursorListener);
                santongComponent.repaint();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.model.isEditable()) {
            this.model.setUnsavedChanges(true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

