/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SantongViewPrinter
implements Printable {
    private static String HEADER_FONT_FAMILY = "Monospaced";
    private static int HEADER_FONT_SIZE = 10;
    private static int HEADER_FONT_STYLE = 0;
    private static float HEADER_LINESPACE_FACTOR = 1.1f;
    private static int HEADER_LINE_COUNT = 4;
    private static String errMsg = "An error occurred while printing the island";
    SantongView theIsland;
    String[] headerLines = new String[3];
    private PrinterJob islandPrinter;
    private PageFormat islandPageFormat;
    private Font headerFont = new Font(HEADER_FONT_FAMILY, HEADER_FONT_STYLE, HEADER_FONT_SIZE);
    private int lineSpacing;
    private int headerHeight;
    private int paddedHeaderHeight;
    private int headerStartY;
    private JPanel headerPanel = new JPanel();
    private JPanel printPanel = new JPanel();
    private JFrame printFrame = new JFrame();
    private Container printPane = this.printFrame.getContentPane();

    public SantongViewPrinter() {
        this.islandPrinter = PrinterJob.getPrinterJob();
        this.islandPageFormat = this.islandPrinter.defaultPage();
        this.lineSpacing = (int)((float)HEADER_FONT_SIZE * HEADER_LINESPACE_FACTOR);
        this.headerHeight = HEADER_LINE_COUNT * this.lineSpacing;
        this.paddedHeaderHeight = this.headerHeight + 2 * this.lineSpacing;
    }

    public void print(String string, String string2, SantongView santongView) {
        this.theIsland = santongView;
        this.headerLines[0] = "     SANTONG ISLAND OVERVIEW";
        this.headerLines[1] = "     FILE: " + string;
        this.headerLines[2] = "     " + string2;
        if (this.islandPrinter.printDialog()) {
            try {
                this.islandPrinter.setPrintable(this);
                this.islandPrinter.print();
            }
            catch (PrinterException printerException) {
                JOptionPane.showMessageDialog(null, errMsg + ": " + printerException.getMessage(), "Printing Error", 0);
            }
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n > 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        this.theIsland.paint(graphics2D);
        graphics2D.translate(-pageFormat.getImageableX(), -pageFormat.getImageableY());
        this.headerStartY = (int)pageFormat.getImageableHeight() - this.headerHeight;
        graphics2D.setColor(Color.LIGHT_GRAY);
        graphics2D.fillRoundRect((int)pageFormat.getImageableX(), this.headerStartY, (int)pageFormat.getImageableWidth(), this.headerHeight, 10, 10);
        graphics2D.setFont(this.headerFont);
        graphics2D.setColor(Color.BLACK);
        int n2 = (int)pageFormat.getImageableX();
        int n3 = this.headerStartY + this.lineSpacing;
        graphics2D.drawString(this.headerLines[0], n2, n3);
        graphics2D.drawString(this.headerLines[1], n2, n3 += this.lineSpacing);
        graphics2D.drawString(this.headerLines[2], n2, n3 += this.lineSpacing);
        return 0;
    }
}

