/*
 * Decompiled with CFR 0.152.
 */
import java.util.Stack;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class SourceUndoManager
extends UndoManager {
    private Stack undoToStack = new Stack();
    private Stack redoToStack = new Stack();
    private String lastEditName = "";
    private boolean creatingUndoGroup = false;
    private boolean groupIsEmpty;
    private static SourceUndoManager instance = new SourceUndoManager();

    private SourceUndoManager() {
    }

    public static SourceUndoManager getInstance() {
        return instance;
    }

    @Override
    public boolean addEdit(UndoableEdit undoableEdit) {
        if (this.creatingUndoGroup) {
            if (this.groupIsEmpty) {
                this.undoToStack.push(new EditNode(this.lastEditName, undoableEdit));
                this.groupIsEmpty = false;
            }
        } else {
            String string = undoableEdit.getPresentationName();
            if (this.undoToStack.empty() || !string.equals(this.lastEditName)) {
                String string2 = this.extractUndoName(string);
                this.undoToStack.push(new EditNode(string2, undoableEdit));
                this.lastEditName = string;
            }
        }
        return super.addEdit(undoableEdit);
    }

    public void undoEditing() {
        if (this.undoToStack.empty()) {
            this.lastEditName = "";
        } else {
            String string = ((EditNode)this.undoToStack.peek()).getName();
            this.redoToStack.push(new EditNode(string, this.editToBeUndone()));
            UndoableEdit undoableEdit = ((EditNode)this.undoToStack.pop()).getEdit();
            super.undoTo(undoableEdit);
        }
    }

    public void redoEditing() {
        if (!this.redoToStack.isEmpty()) {
            String string = ((EditNode)this.redoToStack.peek()).getName();
            this.undoToStack.push(new EditNode(string, this.editToBeRedone()));
            UndoableEdit undoableEdit = ((EditNode)this.redoToStack.pop()).getEdit();
            super.redoTo(undoableEdit);
        }
    }

    public void markEdits(String string) {
        this.lastEditName = string;
    }

    public void markMouseClick() {
        this.lastEditName = "MOUSE";
    }

    public void reset() {
        this.discardAllEdits();
        this.lastEditName = "";
    }

    private String extractUndoName(String string) {
        String string2 = string.endsWith("addition") ? "typing" : (string.endsWith("deletion") ? "deletion" : string);
        return string2;
    }

    public String getRedoName() {
        if (this.redoToStack.empty()) {
            return "?";
        }
        return ((EditNode)this.redoToStack.peek()).getName();
    }

    public String getUndoName() {
        if (this.undoToStack.empty()) {
            return "?";
        }
        return ((EditNode)this.undoToStack.peek()).getName();
    }

    public void startCut() {
        this.lastEditName = "START CUT";
    }

    public void endCut() {
        this.lastEditName = "END CUT";
        ((EditNode)this.undoToStack.peek()).setName("CUT");
    }

    public void startPaste() {
        this.lastEditName = "START PASTE";
    }

    public void endPaste() {
        this.lastEditName = "END PASTE";
        ((EditNode)this.undoToStack.peek()).setName("PASTE");
    }

    public void startComment() {
        this.lastEditName = "START COMMENT";
    }

    public void endComment() {
        this.lastEditName = "END COMMENT";
        ((EditNode)this.undoToStack.peek()).setName("COMMENT LINES");
    }

    public void startUndoGroup(String string) {
        this.creatingUndoGroup = true;
        this.groupIsEmpty = true;
        this.lastEditName = string;
    }

    public void endUndoGroup() {
        this.creatingUndoGroup = false;
    }

    private class EditNode {
        String name;
        UndoableEdit theEdit;

        private EditNode(String string, UndoableEdit undoableEdit) {
            this.name = string;
            this.theEdit = undoableEdit;
        }

        private UndoableEdit getEdit() {
            return this.theEdit;
        }

        private String getName() {
            return this.name;
        }

        private void setEdit(UndoableEdit undoableEdit) {
            this.theEdit = undoableEdit;
        }

        private void setName(String string) {
            this.name = string;
        }
    }
}

