/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public abstract class TutorialFrame
extends JFrame {
    protected final int PANE_WIDTH = 590;
    protected final int PANE_HEIGHT = 325;
    protected final Dimension PANE_SIZE = new Dimension(590, 325);
    protected final int TUTORIAL_OFFSET_X = 10;
    protected final int TUTORIAL_OFFSET_Y = 155;
    protected Container contentPane;
    protected JScrollPane tutorialScrollPane;
    protected JEditorPane tutorialPane = new JEditorPane();
    protected JPanel buttonPanel = new JPanel(new FlowLayout(1));
    protected JButton quitButton = new JButton("Quit");
    protected JButton copyButton = new JButton("Copy The Code");
    protected JerooSourceArea sourceArea;
    protected URL tutorialURL;

    public TutorialFrame() {
    }

    public TutorialFrame(String string, URL uRL, JerooSourceArea jerooSourceArea) {
        super(string);
        this.tutorialURL = uRL;
        this.sourceArea = jerooSourceArea;
        this.contentPane = this.getContentPane();
        this.tutorialPane.setSize(JerooConstants.TUTORIAL_FRAME_DIMENSION);
        this.tutorialPane.setMinimumSize(JerooConstants.TUTORIAL_FRAME_DIMENSION);
        this.tutorialPane.setPreferredSize(JerooConstants.TUTORIAL_FRAME_DIMENSION);
        this.contentPane.setLayout(new BorderLayout());
        try {
            this.tutorialPane.setEditable(false);
            this.tutorialPane.setPage(uRL);
            this.tutorialScrollPane = new JScrollPane(this.tutorialPane);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TutorialFrame.this.copyTheCode();
            }
        });
        this.quitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TutorialFrame.this.quitTutorial();
            }
        });
        this.buttonPanel.add(this.copyButton);
        this.buttonPanel.add(this.quitButton);
        this.contentPane.add((Component)this.tutorialScrollPane, "Center");
        this.contentPane.add((Component)this.buttonPanel, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                TutorialFrame.this.quitTutorial();
            }
        });
    }

    protected void quitTutorial() {
        this.setVisible(false);
        this.dispose();
    }

    protected void showTutorial(Point point) {
        this.pack();
        this.setLocation((int)point.getX() + 10, (int)point.getY() + 155);
        this.setVisible(true);
    }

    public abstract void copyTheCode();
}

