/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;

public class UserPreferences {
    private final String SOURCE_KEY = "SourceFile_";
    private final String ISLAND_KEY = "IslandFile_";
    public static final String USER_NAME_KEY = "UserName";
    public static final String COURSE_ID_KEY = "CourseID";
    public static final String PROJECT_ID_KEY = "ProjectID";
    public static final String TAB_SIZE_KEY = "TabSize";
    public static final String AUTOINDENT_KEY = "AutoIndent";
    public static final String LANGUAGE_STYLE_KEY = "LanguageStyle";
    public static final String EDITOR_FONT_FAMILY_KEY = "EditorFontFamily";
    public static final String EDITOR_FONT_SIZE_KEY = "EditorFontSize";
    public static final String EDITOR_FONT_STYLE_KEY = "EditorFontStyle";
    public static final String LAST_SOURCE_DIR = "LastSourceDirectory";
    public static final String LAST_ISLAND_DIR = "LastIslandDirectory";
    public static final String DEFAULT_TAB_SIZE = "3";
    public static final String DEFAULT_AUTOINDENT = "true";
    public static final String DEFAULT_STYLE = String.valueOf(0);
    private static UserPreferences instance = new UserPreferences();
    private Properties prefs;
    private String userName = "";
    private File prefFile;
    private Vector sourceFileVector;
    private Vector islandFileVector;
    private PropertyChangeSupport changeReporter = new PropertyChangeSupport(this);
    private String oldTabStr = "";
    private String oldAIStr = "";

    private UserPreferences() {
        this.prefFile = PreferenceFile.getPrefFile();
        this.prefs = new Properties();
        this.sourceFileVector = new Vector(5);
        this.islandFileVector = new Vector(5);
        this.setDefaults();
    }

    public static UserPreferences getInstance() {
        return instance;
    }

    public void setDefaults() {
        Font font = JerooConstants.DEFAULT_SOURCE_FONT;
        this.prefs.setProperty(USER_NAME_KEY, "");
        this.prefs.setProperty(COURSE_ID_KEY, "");
        this.prefs.setProperty(PROJECT_ID_KEY, "");
        this.prefs.setProperty(TAB_SIZE_KEY, DEFAULT_TAB_SIZE);
        this.prefs.setProperty(AUTOINDENT_KEY, DEFAULT_AUTOINDENT);
        this.prefs.setProperty(LANGUAGE_STYLE_KEY, DEFAULT_STYLE);
        this.prefs.setProperty(EDITOR_FONT_FAMILY_KEY, font.getFamily());
        this.prefs.setProperty(EDITOR_FONT_SIZE_KEY, font.getSize() + "");
        this.prefs.setProperty(EDITOR_FONT_STYLE_KEY, font.getStyle() + "");
        this.prefs.setProperty(LAST_SOURCE_DIR, System.getProperty("user.home"));
        this.prefs.setProperty(LAST_ISLAND_DIR, System.getProperty("user.home"));
        for (int i = 0; i < 5; ++i) {
            this.prefs.setProperty("SourceFile_" + i, "");
            this.prefs.setProperty("IslandFile_" + i, "");
        }
        this.checkPropertyChanges();
    }

    public String getPref(String string) {
        return this.prefs.getProperty(string);
    }

    public void setPref(String string, String string2) {
        this.prefs.setProperty(string, string2);
        this.checkPropertyChanges();
        this.saveToFile();
    }

    public void loadFromFile() {
        this.loadFromFile(this.prefFile);
    }

    public void loadFromFile(String string) {
        this.loadFromFile(new File(string));
    }

    public void loadFromFile(File file) {
        int n = 0;
        int n2 = 0;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            this.prefs.load(fileInputStream);
            for (int i = 0; i < 5; ++i) {
                String string = this.prefs.getProperty("SourceFile_" + i);
                if (new File(string).exists()) {
                    this.sourceFileVector.insertElementAt(string, n);
                    ++n;
                }
                if (!new File(string = this.prefs.getProperty("IslandFile_" + i)).exists()) continue;
                this.islandFileVector.insertElementAt(string, n2);
                ++n2;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.checkPropertyChanges();
    }

    public void saveToFile() {
        this.saveToFile(this.prefFile);
    }

    public void saveToFile(String string) {
        this.saveToFile(new File(string));
    }

    public void saveToFile(File file) {
        String string = this.getPref(USER_NAME_KEY);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.prefs.store(fileOutputStream, "Jeroo preferences for " + string);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Font getFont() {
        String string = this.prefs.getProperty(EDITOR_FONT_FAMILY_KEY);
        String string2 = this.prefs.getProperty(EDITOR_FONT_SIZE_KEY);
        String string3 = this.prefs.getProperty(EDITOR_FONT_STYLE_KEY);
        int n = Integer.parseInt(string2);
        int n2 = Integer.parseInt(string3);
        if (string != null && string.length() > 0) {
            return new Font(string, n2, n);
        }
        return JerooConstants.DEFAULT_SOURCE_FONT;
    }

    public int getTabSize() {
        return Integer.parseInt(this.prefs.getProperty(TAB_SIZE_KEY));
    }

    public boolean autoIndentIsSet() {
        return this.prefs.getProperty(AUTOINDENT_KEY).equals(DEFAULT_AUTOINDENT);
    }

    public int getStyleCode() {
        return Integer.parseInt(this.prefs.getProperty(LANGUAGE_STYLE_KEY));
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public Vector getSourceNames() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < 5; ++i) {
            String string = this.prefs.getProperty("SourceFile_" + i);
            if (string.length() <= 0) continue;
            vector.addElement(string);
        }
        return vector;
    }

    public Vector getIslandNames() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < 5; ++i) {
            String string = this.prefs.getProperty("IslandFile_" + i);
            if (string.length() <= 0) continue;
            vector.addElement(string);
        }
        return vector;
    }

    public void setFont(Font font) {
        this.prefs.setProperty(EDITOR_FONT_FAMILY_KEY, font.getFamily());
        this.prefs.setProperty(EDITOR_FONT_SIZE_KEY, "" + font.getSize());
        this.prefs.setProperty(EDITOR_FONT_STYLE_KEY, "" + font.getStyle());
    }

    public void updateRecentSourceFiles(Vector vector) {
        int n;
        this.sourceFileVector = null;
        this.sourceFileVector = (Vector)vector.clone();
        for (n = 0; n < vector.size(); ++n) {
            this.prefs.setProperty("SourceFile_" + n, (String)vector.elementAt(n));
        }
        for (n = vector.size(); n < 5; ++n) {
            this.prefs.setProperty("SourceFile_" + n, "");
        }
        this.saveToFile();
    }

    public void updateRecentIslandFiles(Vector vector) {
        int n;
        for (n = 0; n < vector.size(); ++n) {
            this.prefs.setProperty("IslandFile_" + n, (String)vector.elementAt(n));
        }
        for (n = vector.size(); n < 5; ++n) {
            this.prefs.setProperty("IslandFile_" + n, "");
        }
        this.saveToFile();
    }

    public void checkPropertyChanges() {
        String string = this.prefs.getProperty(TAB_SIZE_KEY);
        String string2 = this.prefs.getProperty(AUTOINDENT_KEY);
        if (!string.equals(this.oldTabStr)) {
            this.changeReporter.firePropertyChange("Tab Property", this.oldTabStr, string);
            this.oldTabStr = string;
        }
        if (!string2.equals(this.oldAIStr)) {
            this.changeReporter.firePropertyChange("Autoindent Property", this.oldAIStr, string2);
            this.oldAIStr = string2;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeReporter.addPropertyChangeListener(propertyChangeListener);
    }

    public void list() {
        this.prefs.list(System.out);
    }
}

