/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileNotFoundException;
import java.util.Enumeration;

public class VBLexicalAnalyzer
extends LexicalAnalyzer {
    public VBLexicalAnalyzer(String string, String string2) throws FileNotFoundException {
        super(string, string2);
        this.caseSensitive = false;
    }

    @Override
    protected boolean isValidIdentifier(String string) {
        char c = string.charAt(0);
        boolean bl = Character.isLetter(c) || c == '_';
        for (int i = 1; i < string.length(); ++i) {
            c = string.charAt(i);
            bl = bl && (Character.isLetterOrDigit(c) || c == '_');
        }
        return bl;
    }

    @Override
    protected void addReservedWords() {
        this.rwSymbols.put("sub", SUBSYM);
        this.rwSymbols.put("end", ENDSYM);
        this.rwSymbols.put("dim", DIMSYM);
        this.rwSymbols.put("as", ASSYM);
        this.rwSymbols.put("and", ANDSYM);
        this.rwSymbols.put("or", ORSYM);
        this.rwSymbols.put("not", NOTSYM);
        this.rwSymbols.put("then", THENSYM);
        this.rwSymbols.put("elseif", ELSIFSYM);
        this.rwSymbols.put("main", MAINSYM);
        Enumeration enumeration = this.rwSymbols.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Integer n = (Integer)this.rwSymbols.get(string);
            this.rwSymbols.remove(string);
            this.rwSymbols.put(string.toUpperCase(), n);
        }
    }

    @Override
    protected void addSymbols() {
    }

    @Override
    protected void configureStreamTokenizer() {
        this.tokenizer.eolIsSignificant(true);
        this.tokenizer.commentChar(39);
        this.tokenizer.slashSlashComments(false);
        this.tokenizer.slashStarComments(false);
        this.tokenizer.ordinaryChar(46);
        this.tokenizer.ordinaryChar(47);
        this.tokenizer.wordChars(64, 64);
        this.tokenizer.wordChars(95, 95);
    }
}

